package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentConfigStatusBuilder extends DeploymentConfigStatusFluent<DeploymentConfigStatusBuilder> implements VisitableBuilder<DeploymentConfigStatus,DeploymentConfigStatusBuilder>{
  public DeploymentConfigStatusBuilder() {
    this(false);
  }
  public DeploymentConfigStatusBuilder(Boolean validationEnabled) {
    this(new DeploymentConfigStatus(), validationEnabled);
  }
  public DeploymentConfigStatusBuilder(DeploymentConfigStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentConfigStatusBuilder(DeploymentConfigStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DeploymentConfigStatus(), validationEnabled);
  }
  public DeploymentConfigStatusBuilder(DeploymentConfigStatusFluent<?> fluent,DeploymentConfigStatus instance) {
    this(fluent, instance, false);
  }
  public DeploymentConfigStatusBuilder(DeploymentConfigStatusFluent<?> fluent,DeploymentConfigStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DeploymentConfigStatus());

    if (instance != null) {
      fluent.withAvailableReplicas(instance.getAvailableReplicas());
      fluent.withConditions(instance.getConditions());
      fluent.withDetails(instance.getDetails());
      fluent.withLatestVersion(instance.getLatestVersion());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReadyReplicas(instance.getReadyReplicas());
      fluent.withReplicas(instance.getReplicas());
      fluent.withUnavailableReplicas(instance.getUnavailableReplicas());
      fluent.withUpdatedReplicas(instance.getUpdatedReplicas());
      fluent.withAvailableReplicas(instance.getAvailableReplicas());
      fluent.withConditions(instance.getConditions());
      fluent.withDetails(instance.getDetails());
      fluent.withLatestVersion(instance.getLatestVersion());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReadyReplicas(instance.getReadyReplicas());
      fluent.withReplicas(instance.getReplicas());
      fluent.withUnavailableReplicas(instance.getUnavailableReplicas());
      fluent.withUpdatedReplicas(instance.getUpdatedReplicas());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DeploymentConfigStatusBuilder(DeploymentConfigStatus instance) {
    this(instance,false);
  }
  public DeploymentConfigStatusBuilder(DeploymentConfigStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DeploymentConfigStatus());

    if (instance != null) {
      this.withAvailableReplicas(instance.getAvailableReplicas());
      this.withConditions(instance.getConditions());
      this.withDetails(instance.getDetails());
      this.withLatestVersion(instance.getLatestVersion());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withReplicas(instance.getReplicas());
      this.withUnavailableReplicas(instance.getUnavailableReplicas());
      this.withUpdatedReplicas(instance.getUpdatedReplicas());
      this.withAvailableReplicas(instance.getAvailableReplicas());
      this.withConditions(instance.getConditions());
      this.withDetails(instance.getDetails());
      this.withLatestVersion(instance.getLatestVersion());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withReplicas(instance.getReplicas());
      this.withUnavailableReplicas(instance.getUnavailableReplicas());
      this.withUpdatedReplicas(instance.getUpdatedReplicas());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DeploymentConfigStatusFluent<?> fluent;
  Boolean validationEnabled;
  public DeploymentConfigStatus build() {
    DeploymentConfigStatus buildable = new DeploymentConfigStatus(fluent.getAvailableReplicas(),fluent.buildConditions(),fluent.buildDetails(),fluent.getLatestVersion(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getReplicas(),fluent.getUnavailableReplicas(),fluent.getUpdatedReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}