package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentTriggerImageChangeParamsBuilder extends DeploymentTriggerImageChangeParamsFluent<DeploymentTriggerImageChangeParamsBuilder> implements VisitableBuilder<DeploymentTriggerImageChangeParams,DeploymentTriggerImageChangeParamsBuilder>{
  public DeploymentTriggerImageChangeParamsBuilder() {
    this(false);
  }
  public DeploymentTriggerImageChangeParamsBuilder(Boolean validationEnabled) {
    this(new DeploymentTriggerImageChangeParams(), validationEnabled);
  }
  public DeploymentTriggerImageChangeParamsBuilder(DeploymentTriggerImageChangeParamsFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentTriggerImageChangeParamsBuilder(DeploymentTriggerImageChangeParamsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DeploymentTriggerImageChangeParams(), validationEnabled);
  }
  public DeploymentTriggerImageChangeParamsBuilder(DeploymentTriggerImageChangeParamsFluent<?> fluent,DeploymentTriggerImageChangeParams instance) {
    this(fluent, instance, false);
  }
  public DeploymentTriggerImageChangeParamsBuilder(DeploymentTriggerImageChangeParamsFluent<?> fluent,DeploymentTriggerImageChangeParams instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DeploymentTriggerImageChangeParams());

    if (instance != null) {
      fluent.withAutomatic(instance.getAutomatic());
      fluent.withContainerNames(instance.getContainerNames());
      fluent.withFrom(instance.getFrom());
      fluent.withLastTriggeredImage(instance.getLastTriggeredImage());
      fluent.withAutomatic(instance.getAutomatic());
      fluent.withContainerNames(instance.getContainerNames());
      fluent.withFrom(instance.getFrom());
      fluent.withLastTriggeredImage(instance.getLastTriggeredImage());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DeploymentTriggerImageChangeParamsBuilder(DeploymentTriggerImageChangeParams instance) {
    this(instance,false);
  }
  public DeploymentTriggerImageChangeParamsBuilder(DeploymentTriggerImageChangeParams instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DeploymentTriggerImageChangeParams());

    if (instance != null) {
      this.withAutomatic(instance.getAutomatic());
      this.withContainerNames(instance.getContainerNames());
      this.withFrom(instance.getFrom());
      this.withLastTriggeredImage(instance.getLastTriggeredImage());
      this.withAutomatic(instance.getAutomatic());
      this.withContainerNames(instance.getContainerNames());
      this.withFrom(instance.getFrom());
      this.withLastTriggeredImage(instance.getLastTriggeredImage());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DeploymentTriggerImageChangeParamsFluent<?> fluent;
  Boolean validationEnabled;
  public DeploymentTriggerImageChangeParams build() {
    DeploymentTriggerImageChangeParams buildable = new DeploymentTriggerImageChangeParams(fluent.getAutomatic(),fluent.getContainerNames(),fluent.buildFrom(),fluent.getLastTriggeredImage());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}