package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DockerStrategyOptionsFluent<A extends DockerStrategyOptionsFluent<A>> extends BaseFluent<A>{
  public DockerStrategyOptionsFluent() {
  }
  public DockerStrategyOptionsFluent(DockerStrategyOptions instance) {
    instance = (instance != null ? instance : new DockerStrategyOptions());

    if (instance != null) {
      this.withBuildArgs(instance.getBuildArgs());
      this.withNoCache(instance.getNoCache());
      this.withBuildArgs(instance.getBuildArgs());
      this.withNoCache(instance.getNoCache());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<EnvVar> buildArgs = new ArrayList<EnvVar>();
  private Boolean noCache;
  private Map<String,Object> additionalProperties;
  public A addToBuildArgs(int index,EnvVar item) {
    if (this.buildArgs == null) {this.buildArgs = new ArrayList<EnvVar>();}
    this.buildArgs.add(index, item);
    return (A)this;
  }
  public A setToBuildArgs(int index,EnvVar item) {
    if (this.buildArgs == null) {this.buildArgs = new ArrayList<EnvVar>();}
    this.buildArgs.set(index, item); return (A)this;
  }
  public A addToBuildArgs(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.buildArgs == null) {this.buildArgs = new ArrayList<EnvVar>();}
    for (EnvVar item : items) {this.buildArgs.add(item);} return (A)this;
  }
  public A addAllToBuildArgs(Collection<EnvVar> items) {
    if (this.buildArgs == null) {this.buildArgs = new ArrayList<EnvVar>();}
    for (EnvVar item : items) {this.buildArgs.add(item);} return (A)this;
  }
  public A removeFromBuildArgs(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.buildArgs == null) return (A)this;
    for (EnvVar item : items) { this.buildArgs.remove(item);} return (A)this;
  }
  public A removeAllFromBuildArgs(Collection<EnvVar> items) {
    if (this.buildArgs == null) return (A)this;
    for (EnvVar item : items) { this.buildArgs.remove(item);} return (A)this;
  }
  public List<EnvVar> getBuildArgs() {
    return this.buildArgs;
  }
  public EnvVar getBuildArg(int index) {
    return this.buildArgs.get(index);
  }
  public EnvVar getFirstBuildArg() {
    return this.buildArgs.get(0);
  }
  public EnvVar getLastBuildArg() {
    return this.buildArgs.get(buildArgs.size() - 1);
  }
  public EnvVar getMatchingBuildArg(Predicate<EnvVar> predicate) {
    for (EnvVar item: buildArgs) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingBuildArg(Predicate<EnvVar> predicate) {
    for (EnvVar item: buildArgs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withBuildArgs(List<EnvVar> buildArgs) {
    if (buildArgs != null) {this.buildArgs = new ArrayList(); for (EnvVar item : buildArgs){this.addToBuildArgs(item);}} else { this.buildArgs = null;} return (A) this;
  }
  public A withBuildArgs(io.fabric8.kubernetes.api.model.EnvVar... buildArgs) {
    if (this.buildArgs != null) {this.buildArgs.clear(); _visitables.remove("buildArgs"); }
    if (buildArgs != null) {for (EnvVar item :buildArgs){ this.addToBuildArgs(item);}} return (A) this;
  }
  public boolean hasBuildArgs() {
    return buildArgs != null && !buildArgs.isEmpty();
  }
  public Boolean getNoCache() {
    return this.noCache;
  }
  public A withNoCache(Boolean noCache) {
    this.noCache=noCache; return (A) this;
  }
  public boolean hasNoCache() {
    return this.noCache != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DockerStrategyOptionsFluent that = (DockerStrategyOptionsFluent) o;
    if (!java.util.Objects.equals(buildArgs, that.buildArgs)) return false;

    if (!java.util.Objects.equals(noCache, that.noCache)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(buildArgs,  noCache,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (buildArgs != null && !buildArgs.isEmpty()) { sb.append("buildArgs:"); sb.append(buildArgs + ","); }
    if (noCache != null) { sb.append("noCache:"); sb.append(noCache + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withNoCache() {
    return withNoCache(true);
  }
  
}