package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class FSGroupStrategyOptionsFluent<A extends FSGroupStrategyOptionsFluent<A>> extends BaseFluent<A>{
  public FSGroupStrategyOptionsFluent() {
  }
  public FSGroupStrategyOptionsFluent(FSGroupStrategyOptions instance) {
    instance = (instance != null ? instance : new FSGroupStrategyOptions());

    if (instance != null) {
      this.withRanges(instance.getRanges());
      this.withType(instance.getType());
      this.withRanges(instance.getRanges());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<IDRangeBuilder> ranges = new ArrayList<IDRangeBuilder>();
  private String type;
  private Map<String,Object> additionalProperties;
  public A addToRanges(int index,IDRange item) {
    if (this.ranges == null) {this.ranges = new ArrayList<IDRangeBuilder>();}
    IDRangeBuilder builder = new IDRangeBuilder(item);
    if (index < 0 || index >= ranges.size()) { _visitables.get("ranges").add(builder); ranges.add(builder); } else { _visitables.get("ranges").add(index, builder); ranges.add(index, builder);}
    return (A)this;
  }
  public A setToRanges(int index,IDRange item) {
    if (this.ranges == null) {this.ranges = new ArrayList<IDRangeBuilder>();}
    IDRangeBuilder builder = new IDRangeBuilder(item);
    if (index < 0 || index >= ranges.size()) { _visitables.get("ranges").add(builder); ranges.add(builder); } else { _visitables.get("ranges").set(index, builder); ranges.set(index, builder);}
    return (A)this;
  }
  public A addToRanges(io.fabric8.openshift.api.model.IDRange... items) {
    if (this.ranges == null) {this.ranges = new ArrayList<IDRangeBuilder>();}
    for (IDRange item : items) {IDRangeBuilder builder = new IDRangeBuilder(item);_visitables.get("ranges").add(builder);this.ranges.add(builder);} return (A)this;
  }
  public A addAllToRanges(Collection<IDRange> items) {
    if (this.ranges == null) {this.ranges = new ArrayList<IDRangeBuilder>();}
    for (IDRange item : items) {IDRangeBuilder builder = new IDRangeBuilder(item);_visitables.get("ranges").add(builder);this.ranges.add(builder);} return (A)this;
  }
  public A removeFromRanges(io.fabric8.openshift.api.model.IDRange... items) {
    if (this.ranges == null) return (A)this;
    for (IDRange item : items) {IDRangeBuilder builder = new IDRangeBuilder(item);_visitables.get("ranges").remove(builder); this.ranges.remove(builder);} return (A)this;
  }
  public A removeAllFromRanges(Collection<IDRange> items) {
    if (this.ranges == null) return (A)this;
    for (IDRange item : items) {IDRangeBuilder builder = new IDRangeBuilder(item);_visitables.get("ranges").remove(builder); this.ranges.remove(builder);} return (A)this;
  }
  public A removeMatchingFromRanges(Predicate<IDRangeBuilder> predicate) {
    if (ranges == null) return (A) this;
    final Iterator<IDRangeBuilder> each = ranges.iterator();
    final List visitables = _visitables.get("ranges");
    while (each.hasNext()) {
      IDRangeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<IDRange> buildRanges() {
    return ranges != null ? build(ranges) : null;
  }
  public IDRange buildRange(int index) {
    return this.ranges.get(index).build();
  }
  public IDRange buildFirstRange() {
    return this.ranges.get(0).build();
  }
  public IDRange buildLastRange() {
    return this.ranges.get(ranges.size() - 1).build();
  }
  public IDRange buildMatchingRange(Predicate<IDRangeBuilder> predicate) {
    for (IDRangeBuilder item: ranges) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingRange(Predicate<IDRangeBuilder> predicate) {
    for (IDRangeBuilder item: ranges) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRanges(List<IDRange> ranges) {
    if (this.ranges != null) { _visitables.get("ranges").clear();}
    if (ranges != null) {this.ranges = new ArrayList(); for (IDRange item : ranges){this.addToRanges(item);}} else { this.ranges = null;} return (A) this;
  }
  public A withRanges(io.fabric8.openshift.api.model.IDRange... ranges) {
    if (this.ranges != null) {this.ranges.clear(); _visitables.remove("ranges"); }
    if (ranges != null) {for (IDRange item :ranges){ this.addToRanges(item);}} return (A) this;
  }
  public boolean hasRanges() {
    return ranges != null && !ranges.isEmpty();
  }
  public A addNewRange(Long max,Long min) {
    return (A)addToRanges(new IDRange(max, min));
  }
  public RangesNested<A> addNewRange() {
    return new RangesNested(-1, null);
  }
  public RangesNested<A> addNewRangeLike(IDRange item) {
    return new RangesNested(-1, item);
  }
  public RangesNested<A> setNewRangeLike(int index,IDRange item) {
    return new RangesNested(index, item);
  }
  public RangesNested<A> editRange(int index) {
    if (ranges.size() <= index) throw new RuntimeException("Can't edit ranges. Index exceeds size.");
    return setNewRangeLike(index, buildRange(index));
  }
  public RangesNested<A> editFirstRange() {
    if (ranges.size() == 0) throw new RuntimeException("Can't edit first ranges. The list is empty.");
    return setNewRangeLike(0, buildRange(0));
  }
  public RangesNested<A> editLastRange() {
    int index = ranges.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ranges. The list is empty.");
    return setNewRangeLike(index, buildRange(index));
  }
  public RangesNested<A> editMatchingRange(Predicate<IDRangeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ranges.size();i++) { 
    if (predicate.test(ranges.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ranges. No match found.");
    return setNewRangeLike(index, buildRange(index));
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public boolean hasType() {
    return this.type != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    FSGroupStrategyOptionsFluent that = (FSGroupStrategyOptionsFluent) o;
    if (!java.util.Objects.equals(ranges, that.ranges)) return false;

    if (!java.util.Objects.equals(type, that.type)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(ranges,  type,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ranges != null && !ranges.isEmpty()) { sb.append("ranges:"); sb.append(ranges + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class RangesNested<N> extends IDRangeFluent<RangesNested<N>> implements Nested<N>{
    RangesNested(int index,IDRange item) {
      this.index = index;
      this.builder = new IDRangeBuilder(this, item);
    }
    IDRangeBuilder builder;
    int index;
    public N and() {
      return (N) FSGroupStrategyOptionsFluent.this.setToRanges(index,builder.build());
    }
    public N endRange() {
      return and();
    }
    
  }
  
}