package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GroupRestrictionBuilder extends GroupRestrictionFluent<GroupRestrictionBuilder> implements VisitableBuilder<GroupRestriction,GroupRestrictionBuilder>{
  public GroupRestrictionBuilder() {
    this(false);
  }
  public GroupRestrictionBuilder(Boolean validationEnabled) {
    this(new GroupRestriction(), validationEnabled);
  }
  public GroupRestrictionBuilder(GroupRestrictionFluent<?> fluent) {
    this(fluent, false);
  }
  public GroupRestrictionBuilder(GroupRestrictionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GroupRestriction(), validationEnabled);
  }
  public GroupRestrictionBuilder(GroupRestrictionFluent<?> fluent,GroupRestriction instance) {
    this(fluent, instance, false);
  }
  public GroupRestrictionBuilder(GroupRestrictionFluent<?> fluent,GroupRestriction instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GroupRestriction());

    if (instance != null) {
      fluent.withGroups(instance.getGroups());
      fluent.withLabels(instance.getLabels());
      fluent.withGroups(instance.getGroups());
      fluent.withLabels(instance.getLabels());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GroupRestrictionBuilder(GroupRestriction instance) {
    this(instance,false);
  }
  public GroupRestrictionBuilder(GroupRestriction instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GroupRestriction());

    if (instance != null) {
      this.withGroups(instance.getGroups());
      this.withLabels(instance.getLabels());
      this.withGroups(instance.getGroups());
      this.withLabels(instance.getLabels());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GroupRestrictionFluent<?> fluent;
  Boolean validationEnabled;
  public GroupRestriction build() {
    GroupRestriction buildable = new GroupRestriction(fluent.getGroups(),fluent.buildLabels());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}