package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IdentityListBuilder extends IdentityListFluent<IdentityListBuilder> implements VisitableBuilder<IdentityList,IdentityListBuilder>{
  public IdentityListBuilder() {
    this(false);
  }
  public IdentityListBuilder(Boolean validationEnabled) {
    this(new IdentityList(), validationEnabled);
  }
  public IdentityListBuilder(IdentityListFluent<?> fluent) {
    this(fluent, false);
  }
  public IdentityListBuilder(IdentityListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IdentityList(), validationEnabled);
  }
  public IdentityListBuilder(IdentityListFluent<?> fluent,IdentityList instance) {
    this(fluent, instance, false);
  }
  public IdentityListBuilder(IdentityListFluent<?> fluent,IdentityList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new IdentityList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IdentityListBuilder(IdentityList instance) {
    this(instance,false);
  }
  public IdentityListBuilder(IdentityList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new IdentityList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IdentityListFluent<?> fluent;
  Boolean validationEnabled;
  public IdentityList build() {
    IdentityList buildable = new IdentityList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}