package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageImportSpecBuilder extends ImageImportSpecFluent<ImageImportSpecBuilder> implements VisitableBuilder<ImageImportSpec,ImageImportSpecBuilder>{
  public ImageImportSpecBuilder() {
    this(false);
  }
  public ImageImportSpecBuilder(Boolean validationEnabled) {
    this(new ImageImportSpec(), validationEnabled);
  }
  public ImageImportSpecBuilder(ImageImportSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageImportSpecBuilder(ImageImportSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageImportSpec(), validationEnabled);
  }
  public ImageImportSpecBuilder(ImageImportSpecFluent<?> fluent,ImageImportSpec instance) {
    this(fluent, instance, false);
  }
  public ImageImportSpecBuilder(ImageImportSpecFluent<?> fluent,ImageImportSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImageImportSpec());

    if (instance != null) {
      fluent.withFrom(instance.getFrom());
      fluent.withImportPolicy(instance.getImportPolicy());
      fluent.withIncludeManifest(instance.getIncludeManifest());
      fluent.withReferencePolicy(instance.getReferencePolicy());
      fluent.withTo(instance.getTo());
      fluent.withFrom(instance.getFrom());
      fluent.withImportPolicy(instance.getImportPolicy());
      fluent.withIncludeManifest(instance.getIncludeManifest());
      fluent.withReferencePolicy(instance.getReferencePolicy());
      fluent.withTo(instance.getTo());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageImportSpecBuilder(ImageImportSpec instance) {
    this(instance,false);
  }
  public ImageImportSpecBuilder(ImageImportSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImageImportSpec());

    if (instance != null) {
      this.withFrom(instance.getFrom());
      this.withImportPolicy(instance.getImportPolicy());
      this.withIncludeManifest(instance.getIncludeManifest());
      this.withReferencePolicy(instance.getReferencePolicy());
      this.withTo(instance.getTo());
      this.withFrom(instance.getFrom());
      this.withImportPolicy(instance.getImportPolicy());
      this.withIncludeManifest(instance.getIncludeManifest());
      this.withReferencePolicy(instance.getReferencePolicy());
      this.withTo(instance.getTo());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageImportSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ImageImportSpec build() {
    ImageImportSpec buildable = new ImageImportSpec(fluent.buildFrom(),fluent.buildImportPolicy(),fluent.getIncludeManifest(),fluent.buildReferencePolicy(),fluent.buildTo());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}