package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageImportStatusBuilder extends ImageImportStatusFluent<ImageImportStatusBuilder> implements VisitableBuilder<ImageImportStatus,ImageImportStatusBuilder>{
  public ImageImportStatusBuilder() {
    this(false);
  }
  public ImageImportStatusBuilder(Boolean validationEnabled) {
    this(new ImageImportStatus(), validationEnabled);
  }
  public ImageImportStatusBuilder(ImageImportStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageImportStatusBuilder(ImageImportStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageImportStatus(), validationEnabled);
  }
  public ImageImportStatusBuilder(ImageImportStatusFluent<?> fluent,ImageImportStatus instance) {
    this(fluent, instance, false);
  }
  public ImageImportStatusBuilder(ImageImportStatusFluent<?> fluent,ImageImportStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImageImportStatus());

    if (instance != null) {
      fluent.withImage(instance.getImage());
      fluent.withManifests(instance.getManifests());
      fluent.withStatus(instance.getStatus());
      fluent.withTag(instance.getTag());
      fluent.withImage(instance.getImage());
      fluent.withManifests(instance.getManifests());
      fluent.withStatus(instance.getStatus());
      fluent.withTag(instance.getTag());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageImportStatusBuilder(ImageImportStatus instance) {
    this(instance,false);
  }
  public ImageImportStatusBuilder(ImageImportStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImageImportStatus());

    if (instance != null) {
      this.withImage(instance.getImage());
      this.withManifests(instance.getManifests());
      this.withStatus(instance.getStatus());
      this.withTag(instance.getTag());
      this.withImage(instance.getImage());
      this.withManifests(instance.getManifests());
      this.withStatus(instance.getStatus());
      this.withTag(instance.getTag());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageImportStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ImageImportStatus build() {
    ImageImportStatus buildable = new ImageImportStatus(fluent.buildImage(),fluent.buildManifests(),fluent.getStatus(),fluent.getTag());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}