package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageStreamImportBuilder extends ImageStreamImportFluent<ImageStreamImportBuilder> implements VisitableBuilder<ImageStreamImport,ImageStreamImportBuilder>{
  public ImageStreamImportBuilder() {
    this(false);
  }
  public ImageStreamImportBuilder(Boolean validationEnabled) {
    this(new ImageStreamImport(), validationEnabled);
  }
  public ImageStreamImportBuilder(ImageStreamImportFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamImportBuilder(ImageStreamImportFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageStreamImport(), validationEnabled);
  }
  public ImageStreamImportBuilder(ImageStreamImportFluent<?> fluent,ImageStreamImport instance) {
    this(fluent, instance, false);
  }
  public ImageStreamImportBuilder(ImageStreamImportFluent<?> fluent,ImageStreamImport instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImageStreamImport());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamImportBuilder(ImageStreamImport instance) {
    this(instance,false);
  }
  public ImageStreamImportBuilder(ImageStreamImport instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImageStreamImport());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageStreamImportFluent<?> fluent;
  Boolean validationEnabled;
  public ImageStreamImport build() {
    ImageStreamImport buildable = new ImageStreamImport(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}