package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ImageStreamStatusFluent<A extends ImageStreamStatusFluent<A>> extends BaseFluent<A>{
  public ImageStreamStatusFluent() {
  }
  public ImageStreamStatusFluent(ImageStreamStatus instance) {
    instance = (instance != null ? instance : new ImageStreamStatus());

    if (instance != null) {
      this.withDockerImageRepository(instance.getDockerImageRepository());
      this.withPublicDockerImageRepository(instance.getPublicDockerImageRepository());
      this.withTags(instance.getTags());
      this.withDockerImageRepository(instance.getDockerImageRepository());
      this.withPublicDockerImageRepository(instance.getPublicDockerImageRepository());
      this.withTags(instance.getTags());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String dockerImageRepository;
  private String publicDockerImageRepository;
  private ArrayList<NamedTagEventListBuilder> tags = new ArrayList<NamedTagEventListBuilder>();
  private Map<String,Object> additionalProperties;
  public String getDockerImageRepository() {
    return this.dockerImageRepository;
  }
  public A withDockerImageRepository(String dockerImageRepository) {
    this.dockerImageRepository=dockerImageRepository; return (A) this;
  }
  public boolean hasDockerImageRepository() {
    return this.dockerImageRepository != null;
  }
  public String getPublicDockerImageRepository() {
    return this.publicDockerImageRepository;
  }
  public A withPublicDockerImageRepository(String publicDockerImageRepository) {
    this.publicDockerImageRepository=publicDockerImageRepository; return (A) this;
  }
  public boolean hasPublicDockerImageRepository() {
    return this.publicDockerImageRepository != null;
  }
  public A addToTags(int index,NamedTagEventList item) {
    if (this.tags == null) {this.tags = new ArrayList<NamedTagEventListBuilder>();}
    NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
    if (index < 0 || index >= tags.size()) { _visitables.get("tags").add(builder); tags.add(builder); } else { _visitables.get("tags").add(index, builder); tags.add(index, builder);}
    return (A)this;
  }
  public A setToTags(int index,NamedTagEventList item) {
    if (this.tags == null) {this.tags = new ArrayList<NamedTagEventListBuilder>();}
    NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);
    if (index < 0 || index >= tags.size()) { _visitables.get("tags").add(builder); tags.add(builder); } else { _visitables.get("tags").set(index, builder); tags.set(index, builder);}
    return (A)this;
  }
  public A addToTags(io.fabric8.openshift.api.model.NamedTagEventList... items) {
    if (this.tags == null) {this.tags = new ArrayList<NamedTagEventListBuilder>();}
    for (NamedTagEventList item : items) {NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);_visitables.get("tags").add(builder);this.tags.add(builder);} return (A)this;
  }
  public A addAllToTags(Collection<NamedTagEventList> items) {
    if (this.tags == null) {this.tags = new ArrayList<NamedTagEventListBuilder>();}
    for (NamedTagEventList item : items) {NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);_visitables.get("tags").add(builder);this.tags.add(builder);} return (A)this;
  }
  public A removeFromTags(io.fabric8.openshift.api.model.NamedTagEventList... items) {
    if (this.tags == null) return (A)this;
    for (NamedTagEventList item : items) {NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);_visitables.get("tags").remove(builder); this.tags.remove(builder);} return (A)this;
  }
  public A removeAllFromTags(Collection<NamedTagEventList> items) {
    if (this.tags == null) return (A)this;
    for (NamedTagEventList item : items) {NamedTagEventListBuilder builder = new NamedTagEventListBuilder(item);_visitables.get("tags").remove(builder); this.tags.remove(builder);} return (A)this;
  }
  public A removeMatchingFromTags(Predicate<NamedTagEventListBuilder> predicate) {
    if (tags == null) return (A) this;
    final Iterator<NamedTagEventListBuilder> each = tags.iterator();
    final List visitables = _visitables.get("tags");
    while (each.hasNext()) {
      NamedTagEventListBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<NamedTagEventList> buildTags() {
    return tags != null ? build(tags) : null;
  }
  public NamedTagEventList buildTag(int index) {
    return this.tags.get(index).build();
  }
  public NamedTagEventList buildFirstTag() {
    return this.tags.get(0).build();
  }
  public NamedTagEventList buildLastTag() {
    return this.tags.get(tags.size() - 1).build();
  }
  public NamedTagEventList buildMatchingTag(Predicate<NamedTagEventListBuilder> predicate) {
    for (NamedTagEventListBuilder item: tags) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingTag(Predicate<NamedTagEventListBuilder> predicate) {
    for (NamedTagEventListBuilder item: tags) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTags(List<NamedTagEventList> tags) {
    if (this.tags != null) { _visitables.get("tags").clear();}
    if (tags != null) {this.tags = new ArrayList(); for (NamedTagEventList item : tags){this.addToTags(item);}} else { this.tags = null;} return (A) this;
  }
  public A withTags(io.fabric8.openshift.api.model.NamedTagEventList... tags) {
    if (this.tags != null) {this.tags.clear(); _visitables.remove("tags"); }
    if (tags != null) {for (NamedTagEventList item :tags){ this.addToTags(item);}} return (A) this;
  }
  public boolean hasTags() {
    return tags != null && !tags.isEmpty();
  }
  public TagsNested<A> addNewTag() {
    return new TagsNested(-1, null);
  }
  public TagsNested<A> addNewTagLike(NamedTagEventList item) {
    return new TagsNested(-1, item);
  }
  public TagsNested<A> setNewTagLike(int index,NamedTagEventList item) {
    return new TagsNested(index, item);
  }
  public TagsNested<A> editTag(int index) {
    if (tags.size() <= index) throw new RuntimeException("Can't edit tags. Index exceeds size.");
    return setNewTagLike(index, buildTag(index));
  }
  public TagsNested<A> editFirstTag() {
    if (tags.size() == 0) throw new RuntimeException("Can't edit first tags. The list is empty.");
    return setNewTagLike(0, buildTag(0));
  }
  public TagsNested<A> editLastTag() {
    int index = tags.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last tags. The list is empty.");
    return setNewTagLike(index, buildTag(index));
  }
  public TagsNested<A> editMatchingTag(Predicate<NamedTagEventListBuilder> predicate) {
    int index = -1;
    for (int i=0;i<tags.size();i++) { 
    if (predicate.test(tags.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching tags. No match found.");
    return setNewTagLike(index, buildTag(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageStreamStatusFluent that = (ImageStreamStatusFluent) o;
    if (!java.util.Objects.equals(dockerImageRepository, that.dockerImageRepository)) return false;

    if (!java.util.Objects.equals(publicDockerImageRepository, that.publicDockerImageRepository)) return false;

    if (!java.util.Objects.equals(tags, that.tags)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(dockerImageRepository,  publicDockerImageRepository,  tags,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (dockerImageRepository != null) { sb.append("dockerImageRepository:"); sb.append(dockerImageRepository + ","); }
    if (publicDockerImageRepository != null) { sb.append("publicDockerImageRepository:"); sb.append(publicDockerImageRepository + ","); }
    if (tags != null && !tags.isEmpty()) { sb.append("tags:"); sb.append(tags + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class TagsNested<N> extends NamedTagEventListFluent<TagsNested<N>> implements Nested<N>{
    TagsNested(int index,NamedTagEventList item) {
      this.index = index;
      this.builder = new NamedTagEventListBuilder(this, item);
    }
    NamedTagEventListBuilder builder;
    int index;
    public N and() {
      return (N) ImageStreamStatusFluent.this.setToTags(index,builder.build());
    }
    public N endTag() {
      return and();
    }
    
  }
  
}