package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageStreamTagReferenceBuilder extends ImageStreamTagReferenceFluent<ImageStreamTagReferenceBuilder> implements VisitableBuilder<ImageStreamTagReference,ImageStreamTagReferenceBuilder>{
  public ImageStreamTagReferenceBuilder() {
    this(false);
  }
  public ImageStreamTagReferenceBuilder(Boolean validationEnabled) {
    this(new ImageStreamTagReference(), validationEnabled);
  }
  public ImageStreamTagReferenceBuilder(ImageStreamTagReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamTagReferenceBuilder(ImageStreamTagReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageStreamTagReference(), validationEnabled);
  }
  public ImageStreamTagReferenceBuilder(ImageStreamTagReferenceFluent<?> fluent,ImageStreamTagReference instance) {
    this(fluent, instance, false);
  }
  public ImageStreamTagReferenceBuilder(ImageStreamTagReferenceFluent<?> fluent,ImageStreamTagReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImageStreamTagReference());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamTagReferenceBuilder(ImageStreamTagReference instance) {
    this(instance,false);
  }
  public ImageStreamTagReferenceBuilder(ImageStreamTagReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImageStreamTagReference());

    if (instance != null) {
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageStreamTagReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public ImageStreamTagReference build() {
    ImageStreamTagReference buildable = new ImageStreamTagReference(fluent.getName(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}