package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OAuthAccessTokenBuilder extends OAuthAccessTokenFluent<OAuthAccessTokenBuilder> implements VisitableBuilder<OAuthAccessToken,OAuthAccessTokenBuilder>{
  public OAuthAccessTokenBuilder() {
    this(false);
  }
  public OAuthAccessTokenBuilder(Boolean validationEnabled) {
    this(new OAuthAccessToken(), validationEnabled);
  }
  public OAuthAccessTokenBuilder(OAuthAccessTokenFluent<?> fluent) {
    this(fluent, false);
  }
  public OAuthAccessTokenBuilder(OAuthAccessTokenFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OAuthAccessToken(), validationEnabled);
  }
  public OAuthAccessTokenBuilder(OAuthAccessTokenFluent<?> fluent,OAuthAccessToken instance) {
    this(fluent, instance, false);
  }
  public OAuthAccessTokenBuilder(OAuthAccessTokenFluent<?> fluent,OAuthAccessToken instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OAuthAccessToken());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withAuthorizeToken(instance.getAuthorizeToken());
      fluent.withClientName(instance.getClientName());
      fluent.withExpiresIn(instance.getExpiresIn());
      fluent.withInactivityTimeoutSeconds(instance.getInactivityTimeoutSeconds());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withRedirectURI(instance.getRedirectURI());
      fluent.withRefreshToken(instance.getRefreshToken());
      fluent.withScopes(instance.getScopes());
      fluent.withUserName(instance.getUserName());
      fluent.withUserUID(instance.getUserUID());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withAuthorizeToken(instance.getAuthorizeToken());
      fluent.withClientName(instance.getClientName());
      fluent.withExpiresIn(instance.getExpiresIn());
      fluent.withInactivityTimeoutSeconds(instance.getInactivityTimeoutSeconds());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withRedirectURI(instance.getRedirectURI());
      fluent.withRefreshToken(instance.getRefreshToken());
      fluent.withScopes(instance.getScopes());
      fluent.withUserName(instance.getUserName());
      fluent.withUserUID(instance.getUserUID());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OAuthAccessTokenBuilder(OAuthAccessToken instance) {
    this(instance,false);
  }
  public OAuthAccessTokenBuilder(OAuthAccessToken instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OAuthAccessToken());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withAuthorizeToken(instance.getAuthorizeToken());
      this.withClientName(instance.getClientName());
      this.withExpiresIn(instance.getExpiresIn());
      this.withInactivityTimeoutSeconds(instance.getInactivityTimeoutSeconds());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withRedirectURI(instance.getRedirectURI());
      this.withRefreshToken(instance.getRefreshToken());
      this.withScopes(instance.getScopes());
      this.withUserName(instance.getUserName());
      this.withUserUID(instance.getUserUID());
      this.withApiVersion(instance.getApiVersion());
      this.withAuthorizeToken(instance.getAuthorizeToken());
      this.withClientName(instance.getClientName());
      this.withExpiresIn(instance.getExpiresIn());
      this.withInactivityTimeoutSeconds(instance.getInactivityTimeoutSeconds());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withRedirectURI(instance.getRedirectURI());
      this.withRefreshToken(instance.getRefreshToken());
      this.withScopes(instance.getScopes());
      this.withUserName(instance.getUserName());
      this.withUserUID(instance.getUserUID());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OAuthAccessTokenFluent<?> fluent;
  Boolean validationEnabled;
  public OAuthAccessToken build() {
    OAuthAccessToken buildable = new OAuthAccessToken(fluent.getApiVersion(),fluent.getAuthorizeToken(),fluent.getClientName(),fluent.getExpiresIn(),fluent.getInactivityTimeoutSeconds(),fluent.getKind(),fluent.buildMetadata(),fluent.getRedirectURI(),fluent.getRefreshToken(),fluent.getScopes(),fluent.getUserName(),fluent.getUserUID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}