package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RouteIngressConditionBuilder extends RouteIngressConditionFluent<RouteIngressConditionBuilder> implements VisitableBuilder<RouteIngressCondition,RouteIngressConditionBuilder>{
  public RouteIngressConditionBuilder() {
    this(false);
  }
  public RouteIngressConditionBuilder(Boolean validationEnabled) {
    this(new RouteIngressCondition(), validationEnabled);
  }
  public RouteIngressConditionBuilder(RouteIngressConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public RouteIngressConditionBuilder(RouteIngressConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RouteIngressCondition(), validationEnabled);
  }
  public RouteIngressConditionBuilder(RouteIngressConditionFluent<?> fluent,RouteIngressCondition instance) {
    this(fluent, instance, false);
  }
  public RouteIngressConditionBuilder(RouteIngressConditionFluent<?> fluent,RouteIngressCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RouteIngressCondition());

    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RouteIngressConditionBuilder(RouteIngressCondition instance) {
    this(instance,false);
  }
  public RouteIngressConditionBuilder(RouteIngressCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RouteIngressCondition());

    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RouteIngressConditionFluent<?> fluent;
  Boolean validationEnabled;
  public RouteIngressCondition build() {
    RouteIngressCondition buildable = new RouteIngressCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}