package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RouteSpecFluent<A extends RouteSpecFluent<A>> extends BaseFluent<A>{
  public RouteSpecFluent() {
  }
  public RouteSpecFluent(RouteSpec instance) {
    instance = (instance != null ? instance : new RouteSpec());

    if (instance != null) {
      this.withAlternateBackends(instance.getAlternateBackends());
      this.withHost(instance.getHost());
      this.withPath(instance.getPath());
      this.withPort(instance.getPort());
      this.withSubdomain(instance.getSubdomain());
      this.withTls(instance.getTls());
      this.withTo(instance.getTo());
      this.withWildcardPolicy(instance.getWildcardPolicy());
      this.withAlternateBackends(instance.getAlternateBackends());
      this.withHost(instance.getHost());
      this.withPath(instance.getPath());
      this.withPort(instance.getPort());
      this.withSubdomain(instance.getSubdomain());
      this.withTls(instance.getTls());
      this.withTo(instance.getTo());
      this.withWildcardPolicy(instance.getWildcardPolicy());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<RouteTargetReferenceBuilder> alternateBackends = new ArrayList<RouteTargetReferenceBuilder>();
  private String host;
  private String path;
  private RoutePortBuilder port;
  private String subdomain;
  private TLSConfigBuilder tls;
  private RouteTargetReferenceBuilder to;
  private String wildcardPolicy;
  private Map<String,Object> additionalProperties;
  public A addToAlternateBackends(int index,RouteTargetReference item) {
    if (this.alternateBackends == null) {this.alternateBackends = new ArrayList<RouteTargetReferenceBuilder>();}
    RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);
    if (index < 0 || index >= alternateBackends.size()) { _visitables.get("alternateBackends").add(builder); alternateBackends.add(builder); } else { _visitables.get("alternateBackends").add(index, builder); alternateBackends.add(index, builder);}
    return (A)this;
  }
  public A setToAlternateBackends(int index,RouteTargetReference item) {
    if (this.alternateBackends == null) {this.alternateBackends = new ArrayList<RouteTargetReferenceBuilder>();}
    RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);
    if (index < 0 || index >= alternateBackends.size()) { _visitables.get("alternateBackends").add(builder); alternateBackends.add(builder); } else { _visitables.get("alternateBackends").set(index, builder); alternateBackends.set(index, builder);}
    return (A)this;
  }
  public A addToAlternateBackends(io.fabric8.openshift.api.model.RouteTargetReference... items) {
    if (this.alternateBackends == null) {this.alternateBackends = new ArrayList<RouteTargetReferenceBuilder>();}
    for (RouteTargetReference item : items) {RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);_visitables.get("alternateBackends").add(builder);this.alternateBackends.add(builder);} return (A)this;
  }
  public A addAllToAlternateBackends(Collection<RouteTargetReference> items) {
    if (this.alternateBackends == null) {this.alternateBackends = new ArrayList<RouteTargetReferenceBuilder>();}
    for (RouteTargetReference item : items) {RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);_visitables.get("alternateBackends").add(builder);this.alternateBackends.add(builder);} return (A)this;
  }
  public A removeFromAlternateBackends(io.fabric8.openshift.api.model.RouteTargetReference... items) {
    if (this.alternateBackends == null) return (A)this;
    for (RouteTargetReference item : items) {RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);_visitables.get("alternateBackends").remove(builder); this.alternateBackends.remove(builder);} return (A)this;
  }
  public A removeAllFromAlternateBackends(Collection<RouteTargetReference> items) {
    if (this.alternateBackends == null) return (A)this;
    for (RouteTargetReference item : items) {RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);_visitables.get("alternateBackends").remove(builder); this.alternateBackends.remove(builder);} return (A)this;
  }
  public A removeMatchingFromAlternateBackends(Predicate<RouteTargetReferenceBuilder> predicate) {
    if (alternateBackends == null) return (A) this;
    final Iterator<RouteTargetReferenceBuilder> each = alternateBackends.iterator();
    final List visitables = _visitables.get("alternateBackends");
    while (each.hasNext()) {
      RouteTargetReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<RouteTargetReference> buildAlternateBackends() {
    return alternateBackends != null ? build(alternateBackends) : null;
  }
  public RouteTargetReference buildAlternateBackend(int index) {
    return this.alternateBackends.get(index).build();
  }
  public RouteTargetReference buildFirstAlternateBackend() {
    return this.alternateBackends.get(0).build();
  }
  public RouteTargetReference buildLastAlternateBackend() {
    return this.alternateBackends.get(alternateBackends.size() - 1).build();
  }
  public RouteTargetReference buildMatchingAlternateBackend(Predicate<RouteTargetReferenceBuilder> predicate) {
    for (RouteTargetReferenceBuilder item: alternateBackends) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingAlternateBackend(Predicate<RouteTargetReferenceBuilder> predicate) {
    for (RouteTargetReferenceBuilder item: alternateBackends) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAlternateBackends(List<RouteTargetReference> alternateBackends) {
    if (this.alternateBackends != null) { _visitables.get("alternateBackends").clear();}
    if (alternateBackends != null) {this.alternateBackends = new ArrayList(); for (RouteTargetReference item : alternateBackends){this.addToAlternateBackends(item);}} else { this.alternateBackends = null;} return (A) this;
  }
  public A withAlternateBackends(io.fabric8.openshift.api.model.RouteTargetReference... alternateBackends) {
    if (this.alternateBackends != null) {this.alternateBackends.clear(); _visitables.remove("alternateBackends"); }
    if (alternateBackends != null) {for (RouteTargetReference item :alternateBackends){ this.addToAlternateBackends(item);}} return (A) this;
  }
  public boolean hasAlternateBackends() {
    return alternateBackends != null && !alternateBackends.isEmpty();
  }
  public A addNewAlternateBackend(String kind,String name,Integer weight) {
    return (A)addToAlternateBackends(new RouteTargetReference(kind, name, weight));
  }
  public AlternateBackendsNested<A> addNewAlternateBackend() {
    return new AlternateBackendsNested(-1, null);
  }
  public AlternateBackendsNested<A> addNewAlternateBackendLike(RouteTargetReference item) {
    return new AlternateBackendsNested(-1, item);
  }
  public AlternateBackendsNested<A> setNewAlternateBackendLike(int index,RouteTargetReference item) {
    return new AlternateBackendsNested(index, item);
  }
  public AlternateBackendsNested<A> editAlternateBackend(int index) {
    if (alternateBackends.size() <= index) throw new RuntimeException("Can't edit alternateBackends. Index exceeds size.");
    return setNewAlternateBackendLike(index, buildAlternateBackend(index));
  }
  public AlternateBackendsNested<A> editFirstAlternateBackend() {
    if (alternateBackends.size() == 0) throw new RuntimeException("Can't edit first alternateBackends. The list is empty.");
    return setNewAlternateBackendLike(0, buildAlternateBackend(0));
  }
  public AlternateBackendsNested<A> editLastAlternateBackend() {
    int index = alternateBackends.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last alternateBackends. The list is empty.");
    return setNewAlternateBackendLike(index, buildAlternateBackend(index));
  }
  public AlternateBackendsNested<A> editMatchingAlternateBackend(Predicate<RouteTargetReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<alternateBackends.size();i++) { 
    if (predicate.test(alternateBackends.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching alternateBackends. No match found.");
    return setNewAlternateBackendLike(index, buildAlternateBackend(index));
  }
  public String getHost() {
    return this.host;
  }
  public A withHost(String host) {
    this.host=host; return (A) this;
  }
  public boolean hasHost() {
    return this.host != null;
  }
  public String getPath() {
    return this.path;
  }
  public A withPath(String path) {
    this.path=path; return (A) this;
  }
  public boolean hasPath() {
    return this.path != null;
  }
  public RoutePort buildPort() {
    return this.port!=null ?this.port.build():null;
  }
  public A withPort(RoutePort port) {
    _visitables.get("port").remove(this.port);
    if (port!=null){ this.port= new RoutePortBuilder(port); _visitables.get("port").add(this.port);} else { this.port = null; _visitables.get("port").remove(this.port); } return (A) this;
  }
  public boolean hasPort() {
    return this.port != null;
  }
  public PortNested<A> withNewPort() {
    return new PortNested(null);
  }
  public PortNested<A> withNewPortLike(RoutePort item) {
    return new PortNested(item);
  }
  public PortNested<A> editPort() {
    return withNewPortLike(java.util.Optional.ofNullable(buildPort()).orElse(null));
  }
  public PortNested<A> editOrNewPort() {
    return withNewPortLike(java.util.Optional.ofNullable(buildPort()).orElse(new RoutePortBuilder().build()));
  }
  public PortNested<A> editOrNewPortLike(RoutePort item) {
    return withNewPortLike(java.util.Optional.ofNullable(buildPort()).orElse(item));
  }
  public String getSubdomain() {
    return this.subdomain;
  }
  public A withSubdomain(String subdomain) {
    this.subdomain=subdomain; return (A) this;
  }
  public boolean hasSubdomain() {
    return this.subdomain != null;
  }
  public TLSConfig buildTls() {
    return this.tls!=null ?this.tls.build():null;
  }
  public A withTls(TLSConfig tls) {
    _visitables.get("tls").remove(this.tls);
    if (tls!=null){ this.tls= new TLSConfigBuilder(tls); _visitables.get("tls").add(this.tls);} else { this.tls = null; _visitables.get("tls").remove(this.tls); } return (A) this;
  }
  public boolean hasTls() {
    return this.tls != null;
  }
  public TlsNested<A> withNewTls() {
    return new TlsNested(null);
  }
  public TlsNested<A> withNewTlsLike(TLSConfig item) {
    return new TlsNested(item);
  }
  public TlsNested<A> editTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(null));
  }
  public TlsNested<A> editOrNewTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(new TLSConfigBuilder().build()));
  }
  public TlsNested<A> editOrNewTlsLike(TLSConfig item) {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(item));
  }
  public RouteTargetReference buildTo() {
    return this.to!=null ?this.to.build():null;
  }
  public A withTo(RouteTargetReference to) {
    _visitables.get("to").remove(this.to);
    if (to!=null){ this.to= new RouteTargetReferenceBuilder(to); _visitables.get("to").add(this.to);} else { this.to = null; _visitables.get("to").remove(this.to); } return (A) this;
  }
  public boolean hasTo() {
    return this.to != null;
  }
  public A withNewTo(String kind,String name,Integer weight) {
    return (A)withTo(new RouteTargetReference(kind, name, weight));
  }
  public ToNested<A> withNewTo() {
    return new ToNested(null);
  }
  public ToNested<A> withNewToLike(RouteTargetReference item) {
    return new ToNested(item);
  }
  public ToNested<A> editTo() {
    return withNewToLike(java.util.Optional.ofNullable(buildTo()).orElse(null));
  }
  public ToNested<A> editOrNewTo() {
    return withNewToLike(java.util.Optional.ofNullable(buildTo()).orElse(new RouteTargetReferenceBuilder().build()));
  }
  public ToNested<A> editOrNewToLike(RouteTargetReference item) {
    return withNewToLike(java.util.Optional.ofNullable(buildTo()).orElse(item));
  }
  public String getWildcardPolicy() {
    return this.wildcardPolicy;
  }
  public A withWildcardPolicy(String wildcardPolicy) {
    this.wildcardPolicy=wildcardPolicy; return (A) this;
  }
  public boolean hasWildcardPolicy() {
    return this.wildcardPolicy != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RouteSpecFluent that = (RouteSpecFluent) o;
    if (!java.util.Objects.equals(alternateBackends, that.alternateBackends)) return false;

    if (!java.util.Objects.equals(host, that.host)) return false;

    if (!java.util.Objects.equals(path, that.path)) return false;

    if (!java.util.Objects.equals(port, that.port)) return false;

    if (!java.util.Objects.equals(subdomain, that.subdomain)) return false;

    if (!java.util.Objects.equals(tls, that.tls)) return false;

    if (!java.util.Objects.equals(to, that.to)) return false;

    if (!java.util.Objects.equals(wildcardPolicy, that.wildcardPolicy)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(alternateBackends,  host,  path,  port,  subdomain,  tls,  to,  wildcardPolicy,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (alternateBackends != null && !alternateBackends.isEmpty()) { sb.append("alternateBackends:"); sb.append(alternateBackends + ","); }
    if (host != null) { sb.append("host:"); sb.append(host + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (subdomain != null) { sb.append("subdomain:"); sb.append(subdomain + ","); }
    if (tls != null) { sb.append("tls:"); sb.append(tls + ","); }
    if (to != null) { sb.append("to:"); sb.append(to + ","); }
    if (wildcardPolicy != null) { sb.append("wildcardPolicy:"); sb.append(wildcardPolicy + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AlternateBackendsNested<N> extends RouteTargetReferenceFluent<AlternateBackendsNested<N>> implements Nested<N>{
    AlternateBackendsNested(int index,RouteTargetReference item) {
      this.index = index;
      this.builder = new RouteTargetReferenceBuilder(this, item);
    }
    RouteTargetReferenceBuilder builder;
    int index;
    public N and() {
      return (N) RouteSpecFluent.this.setToAlternateBackends(index,builder.build());
    }
    public N endAlternateBackend() {
      return and();
    }
    
  }
  public class PortNested<N> extends RoutePortFluent<PortNested<N>> implements Nested<N>{
    PortNested(RoutePort item) {
      this.builder = new RoutePortBuilder(this, item);
    }
    RoutePortBuilder builder;
    public N and() {
      return (N) RouteSpecFluent.this.withPort(builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  public class TlsNested<N> extends TLSConfigFluent<TlsNested<N>> implements Nested<N>{
    TlsNested(TLSConfig item) {
      this.builder = new TLSConfigBuilder(this, item);
    }
    TLSConfigBuilder builder;
    public N and() {
      return (N) RouteSpecFluent.this.withTls(builder.build());
    }
    public N endTls() {
      return and();
    }
    
  }
  public class ToNested<N> extends RouteTargetReferenceFluent<ToNested<N>> implements Nested<N>{
    ToNested(RouteTargetReference item) {
      this.builder = new RouteTargetReferenceBuilder(this, item);
    }
    RouteTargetReferenceBuilder builder;
    public N and() {
      return (N) RouteSpecFluent.this.withTo(builder.build());
    }
    public N endTo() {
      return and();
    }
    
  }
  
}