package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class UserBuilder extends UserFluent<UserBuilder> implements VisitableBuilder<User,UserBuilder>{
  public UserBuilder() {
    this(false);
  }
  public UserBuilder(Boolean validationEnabled) {
    this(new User(), validationEnabled);
  }
  public UserBuilder(UserFluent<?> fluent) {
    this(fluent, false);
  }
  public UserBuilder(UserFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new User(), validationEnabled);
  }
  public UserBuilder(UserFluent<?> fluent,User instance) {
    this(fluent, instance, false);
  }
  public UserBuilder(UserFluent<?> fluent,User instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new User());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withFullName(instance.getFullName());
      fluent.withGroups(instance.getGroups());
      fluent.withIdentities(instance.getIdentities());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withFullName(instance.getFullName());
      fluent.withGroups(instance.getGroups());
      fluent.withIdentities(instance.getIdentities());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public UserBuilder(User instance) {
    this(instance,false);
  }
  public UserBuilder(User instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new User());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withFullName(instance.getFullName());
      this.withGroups(instance.getGroups());
      this.withIdentities(instance.getIdentities());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withFullName(instance.getFullName());
      this.withGroups(instance.getGroups());
      this.withIdentities(instance.getIdentities());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  UserFluent<?> fluent;
  Boolean validationEnabled;
  public User build() {
    User buildable = new User(fluent.getApiVersion(),fluent.getFullName(),fluent.getGroups(),fluent.getIdentities(),fluent.getKind(),fluent.buildMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}