package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BitbucketWebHookCauseBuilder extends BitbucketWebHookCauseFluent<BitbucketWebHookCauseBuilder> implements VisitableBuilder<BitbucketWebHookCause,BitbucketWebHookCauseBuilder>{
  public BitbucketWebHookCauseBuilder() {
    this(false);
  }
  public BitbucketWebHookCauseBuilder(Boolean validationEnabled) {
    this(new BitbucketWebHookCause(), validationEnabled);
  }
  public BitbucketWebHookCauseBuilder(BitbucketWebHookCauseFluent<?> fluent) {
    this(fluent, false);
  }
  public BitbucketWebHookCauseBuilder(BitbucketWebHookCauseFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BitbucketWebHookCause(), validationEnabled);
  }
  public BitbucketWebHookCauseBuilder(BitbucketWebHookCauseFluent<?> fluent,BitbucketWebHookCause instance) {
    this(fluent, instance, false);
  }
  public BitbucketWebHookCauseBuilder(BitbucketWebHookCauseFluent<?> fluent,BitbucketWebHookCause instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new BitbucketWebHookCause());

    if (instance != null) {
      fluent.withRevision(instance.getRevision());
      fluent.withSecret(instance.getSecret());
      fluent.withRevision(instance.getRevision());
      fluent.withSecret(instance.getSecret());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BitbucketWebHookCauseBuilder(BitbucketWebHookCause instance) {
    this(instance,false);
  }
  public BitbucketWebHookCauseBuilder(BitbucketWebHookCause instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new BitbucketWebHookCause());

    if (instance != null) {
      this.withRevision(instance.getRevision());
      this.withSecret(instance.getSecret());
      this.withRevision(instance.getRevision());
      this.withSecret(instance.getSecret());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BitbucketWebHookCauseFluent<?> fluent;
  Boolean validationEnabled;
  public BitbucketWebHookCause build() {
    BitbucketWebHookCause buildable = new BitbucketWebHookCause(fluent.buildRevision(),fluent.getSecret());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}