package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BrokerTemplateInstanceListBuilder extends BrokerTemplateInstanceListFluent<BrokerTemplateInstanceListBuilder> implements VisitableBuilder<BrokerTemplateInstanceList,BrokerTemplateInstanceListBuilder>{
  public BrokerTemplateInstanceListBuilder() {
    this(false);
  }
  public BrokerTemplateInstanceListBuilder(Boolean validationEnabled) {
    this(new BrokerTemplateInstanceList(), validationEnabled);
  }
  public BrokerTemplateInstanceListBuilder(BrokerTemplateInstanceListFluent<?> fluent) {
    this(fluent, false);
  }
  public BrokerTemplateInstanceListBuilder(BrokerTemplateInstanceListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BrokerTemplateInstanceList(), validationEnabled);
  }
  public BrokerTemplateInstanceListBuilder(BrokerTemplateInstanceListFluent<?> fluent,BrokerTemplateInstanceList instance) {
    this(fluent, instance, false);
  }
  public BrokerTemplateInstanceListBuilder(BrokerTemplateInstanceListFluent<?> fluent,BrokerTemplateInstanceList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new BrokerTemplateInstanceList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BrokerTemplateInstanceListBuilder(BrokerTemplateInstanceList instance) {
    this(instance,false);
  }
  public BrokerTemplateInstanceListBuilder(BrokerTemplateInstanceList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new BrokerTemplateInstanceList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BrokerTemplateInstanceListFluent<?> fluent;
  Boolean validationEnabled;
  public BrokerTemplateInstanceList build() {
    BrokerTemplateInstanceList buildable = new BrokerTemplateInstanceList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}