package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class BrokerTemplateInstanceSpecFluent<A extends BrokerTemplateInstanceSpecFluent<A>> extends BaseFluent<A>{
  public BrokerTemplateInstanceSpecFluent() {
  }
  public BrokerTemplateInstanceSpecFluent(BrokerTemplateInstanceSpec instance) {
    instance = (instance != null ? instance : new BrokerTemplateInstanceSpec());

    if (instance != null) {
      this.withBindingIDs(instance.getBindingIDs());
      this.withSecret(instance.getSecret());
      this.withTemplateInstance(instance.getTemplateInstance());
      this.withBindingIDs(instance.getBindingIDs());
      this.withSecret(instance.getSecret());
      this.withTemplateInstance(instance.getTemplateInstance());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<String> bindingIDs = new ArrayList<String>();
  private ObjectReferenceBuilder secret;
  private ObjectReferenceBuilder templateInstance;
  private Map<String,Object> additionalProperties;
  public A addToBindingIDs(int index,String item) {
    if (this.bindingIDs == null) {this.bindingIDs = new ArrayList<String>();}
    this.bindingIDs.add(index, item);
    return (A)this;
  }
  public A setToBindingIDs(int index,String item) {
    if (this.bindingIDs == null) {this.bindingIDs = new ArrayList<String>();}
    this.bindingIDs.set(index, item); return (A)this;
  }
  public A addToBindingIDs(java.lang.String... items) {
    if (this.bindingIDs == null) {this.bindingIDs = new ArrayList<String>();}
    for (String item : items) {this.bindingIDs.add(item);} return (A)this;
  }
  public A addAllToBindingIDs(Collection<String> items) {
    if (this.bindingIDs == null) {this.bindingIDs = new ArrayList<String>();}
    for (String item : items) {this.bindingIDs.add(item);} return (A)this;
  }
  public A removeFromBindingIDs(java.lang.String... items) {
    if (this.bindingIDs == null) return (A)this;
    for (String item : items) { this.bindingIDs.remove(item);} return (A)this;
  }
  public A removeAllFromBindingIDs(Collection<String> items) {
    if (this.bindingIDs == null) return (A)this;
    for (String item : items) { this.bindingIDs.remove(item);} return (A)this;
  }
  public List<String> getBindingIDs() {
    return this.bindingIDs;
  }
  public String getBindingID(int index) {
    return this.bindingIDs.get(index);
  }
  public String getFirstBindingID() {
    return this.bindingIDs.get(0);
  }
  public String getLastBindingID() {
    return this.bindingIDs.get(bindingIDs.size() - 1);
  }
  public String getMatchingBindingID(Predicate<String> predicate) {
    for (String item: bindingIDs) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingBindingID(Predicate<String> predicate) {
    for (String item: bindingIDs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withBindingIDs(List<String> bindingIDs) {
    if (bindingIDs != null) {this.bindingIDs = new ArrayList(); for (String item : bindingIDs){this.addToBindingIDs(item);}} else { this.bindingIDs = null;} return (A) this;
  }
  public A withBindingIDs(java.lang.String... bindingIDs) {
    if (this.bindingIDs != null) {this.bindingIDs.clear(); _visitables.remove("bindingIDs"); }
    if (bindingIDs != null) {for (String item :bindingIDs){ this.addToBindingIDs(item);}} return (A) this;
  }
  public boolean hasBindingIDs() {
    return bindingIDs != null && !bindingIDs.isEmpty();
  }
  public ObjectReference buildSecret() {
    return this.secret!=null ?this.secret.build():null;
  }
  public A withSecret(ObjectReference secret) {
    _visitables.get("secret").remove(this.secret);
    if (secret!=null){ this.secret= new ObjectReferenceBuilder(secret); _visitables.get("secret").add(this.secret);} else { this.secret = null; _visitables.get("secret").remove(this.secret); } return (A) this;
  }
  public boolean hasSecret() {
    return this.secret != null;
  }
  public SecretNested<A> withNewSecret() {
    return new SecretNested(null);
  }
  public SecretNested<A> withNewSecretLike(ObjectReference item) {
    return new SecretNested(item);
  }
  public SecretNested<A> editSecret() {
    return withNewSecretLike(java.util.Optional.ofNullable(buildSecret()).orElse(null));
  }
  public SecretNested<A> editOrNewSecret() {
    return withNewSecretLike(java.util.Optional.ofNullable(buildSecret()).orElse(new ObjectReferenceBuilder().build()));
  }
  public SecretNested<A> editOrNewSecretLike(ObjectReference item) {
    return withNewSecretLike(java.util.Optional.ofNullable(buildSecret()).orElse(item));
  }
  public ObjectReference buildTemplateInstance() {
    return this.templateInstance!=null ?this.templateInstance.build():null;
  }
  public A withTemplateInstance(ObjectReference templateInstance) {
    _visitables.get("templateInstance").remove(this.templateInstance);
    if (templateInstance!=null){ this.templateInstance= new ObjectReferenceBuilder(templateInstance); _visitables.get("templateInstance").add(this.templateInstance);} else { this.templateInstance = null; _visitables.get("templateInstance").remove(this.templateInstance); } return (A) this;
  }
  public boolean hasTemplateInstance() {
    return this.templateInstance != null;
  }
  public TemplateInstanceNested<A> withNewTemplateInstance() {
    return new TemplateInstanceNested(null);
  }
  public TemplateInstanceNested<A> withNewTemplateInstanceLike(ObjectReference item) {
    return new TemplateInstanceNested(item);
  }
  public TemplateInstanceNested<A> editTemplateInstance() {
    return withNewTemplateInstanceLike(java.util.Optional.ofNullable(buildTemplateInstance()).orElse(null));
  }
  public TemplateInstanceNested<A> editOrNewTemplateInstance() {
    return withNewTemplateInstanceLike(java.util.Optional.ofNullable(buildTemplateInstance()).orElse(new ObjectReferenceBuilder().build()));
  }
  public TemplateInstanceNested<A> editOrNewTemplateInstanceLike(ObjectReference item) {
    return withNewTemplateInstanceLike(java.util.Optional.ofNullable(buildTemplateInstance()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BrokerTemplateInstanceSpecFluent that = (BrokerTemplateInstanceSpecFluent) o;
    if (!java.util.Objects.equals(bindingIDs, that.bindingIDs)) return false;

    if (!java.util.Objects.equals(secret, that.secret)) return false;

    if (!java.util.Objects.equals(templateInstance, that.templateInstance)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(bindingIDs,  secret,  templateInstance,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bindingIDs != null && !bindingIDs.isEmpty()) { sb.append("bindingIDs:"); sb.append(bindingIDs + ","); }
    if (secret != null) { sb.append("secret:"); sb.append(secret + ","); }
    if (templateInstance != null) { sb.append("templateInstance:"); sb.append(templateInstance + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class SecretNested<N> extends ObjectReferenceFluent<SecretNested<N>> implements Nested<N>{
    SecretNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) BrokerTemplateInstanceSpecFluent.this.withSecret(builder.build());
    }
    public N endSecret() {
      return and();
    }
    
  }
  public class TemplateInstanceNested<N> extends ObjectReferenceFluent<TemplateInstanceNested<N>> implements Nested<N>{
    TemplateInstanceNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) BrokerTemplateInstanceSpecFluent.this.withTemplateInstance(builder.build());
    }
    public N endTemplateInstance() {
      return and();
    }
    
  }
  
}