package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildVolumeBuilder extends BuildVolumeFluent<BuildVolumeBuilder> implements VisitableBuilder<BuildVolume,BuildVolumeBuilder>{
  public BuildVolumeBuilder() {
    this(false);
  }
  public BuildVolumeBuilder(Boolean validationEnabled) {
    this(new BuildVolume(), validationEnabled);
  }
  public BuildVolumeBuilder(BuildVolumeFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildVolumeBuilder(BuildVolumeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BuildVolume(), validationEnabled);
  }
  public BuildVolumeBuilder(BuildVolumeFluent<?> fluent,BuildVolume instance) {
    this(fluent, instance, false);
  }
  public BuildVolumeBuilder(BuildVolumeFluent<?> fluent,BuildVolume instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new BuildVolume());

    if (instance != null) {
      fluent.withMounts(instance.getMounts());
      fluent.withName(instance.getName());
      fluent.withSource(instance.getSource());
      fluent.withMounts(instance.getMounts());
      fluent.withName(instance.getName());
      fluent.withSource(instance.getSource());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BuildVolumeBuilder(BuildVolume instance) {
    this(instance,false);
  }
  public BuildVolumeBuilder(BuildVolume instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new BuildVolume());

    if (instance != null) {
      this.withMounts(instance.getMounts());
      this.withName(instance.getName());
      this.withSource(instance.getSource());
      this.withMounts(instance.getMounts());
      this.withName(instance.getName());
      this.withSource(instance.getSource());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BuildVolumeFluent<?> fluent;
  Boolean validationEnabled;
  public BuildVolume build() {
    BuildVolume buildable = new BuildVolume(fluent.buildMounts(),fluent.getName(),fluent.buildSource());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}