package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterResourceQuotaStatusBuilder extends ClusterResourceQuotaStatusFluent<ClusterResourceQuotaStatusBuilder> implements VisitableBuilder<ClusterResourceQuotaStatus,ClusterResourceQuotaStatusBuilder>{
  public ClusterResourceQuotaStatusBuilder() {
    this(false);
  }
  public ClusterResourceQuotaStatusBuilder(Boolean validationEnabled) {
    this(new ClusterResourceQuotaStatus(), validationEnabled);
  }
  public ClusterResourceQuotaStatusBuilder(ClusterResourceQuotaStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterResourceQuotaStatusBuilder(ClusterResourceQuotaStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterResourceQuotaStatus(), validationEnabled);
  }
  public ClusterResourceQuotaStatusBuilder(ClusterResourceQuotaStatusFluent<?> fluent,ClusterResourceQuotaStatus instance) {
    this(fluent, instance, false);
  }
  public ClusterResourceQuotaStatusBuilder(ClusterResourceQuotaStatusFluent<?> fluent,ClusterResourceQuotaStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterResourceQuotaStatus());

    if (instance != null) {
      fluent.withNamespaces(instance.getNamespaces());
      fluent.withTotal(instance.getTotal());
      fluent.withNamespaces(instance.getNamespaces());
      fluent.withTotal(instance.getTotal());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterResourceQuotaStatusBuilder(ClusterResourceQuotaStatus instance) {
    this(instance,false);
  }
  public ClusterResourceQuotaStatusBuilder(ClusterResourceQuotaStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterResourceQuotaStatus());

    if (instance != null) {
      this.withNamespaces(instance.getNamespaces());
      this.withTotal(instance.getTotal());
      this.withNamespaces(instance.getNamespaces());
      this.withTotal(instance.getTotal());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterResourceQuotaStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterResourceQuotaStatus build() {
    ClusterResourceQuotaStatus buildable = new ClusterResourceQuotaStatus(fluent.buildNamespaces(),fluent.getTotal());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}