package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterRoleBindingBuilder extends ClusterRoleBindingFluent<ClusterRoleBindingBuilder> implements VisitableBuilder<ClusterRoleBinding,ClusterRoleBindingBuilder>{
  public ClusterRoleBindingBuilder() {
    this(false);
  }
  public ClusterRoleBindingBuilder(Boolean validationEnabled) {
    this(new ClusterRoleBinding(), validationEnabled);
  }
  public ClusterRoleBindingBuilder(ClusterRoleBindingFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterRoleBindingBuilder(ClusterRoleBindingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterRoleBinding(), validationEnabled);
  }
  public ClusterRoleBindingBuilder(ClusterRoleBindingFluent<?> fluent,ClusterRoleBinding instance) {
    this(fluent, instance, false);
  }
  public ClusterRoleBindingBuilder(ClusterRoleBindingFluent<?> fluent,ClusterRoleBinding instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterRoleBinding());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withGroupNames(instance.getGroupNames());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withRoleRef(instance.getRoleRef());
      fluent.withSubjects(instance.getSubjects());
      fluent.withUserNames(instance.getUserNames());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withGroupNames(instance.getGroupNames());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withRoleRef(instance.getRoleRef());
      fluent.withSubjects(instance.getSubjects());
      fluent.withUserNames(instance.getUserNames());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterRoleBindingBuilder(ClusterRoleBinding instance) {
    this(instance,false);
  }
  public ClusterRoleBindingBuilder(ClusterRoleBinding instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterRoleBinding());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withGroupNames(instance.getGroupNames());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withRoleRef(instance.getRoleRef());
      this.withSubjects(instance.getSubjects());
      this.withUserNames(instance.getUserNames());
      this.withApiVersion(instance.getApiVersion());
      this.withGroupNames(instance.getGroupNames());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withRoleRef(instance.getRoleRef());
      this.withSubjects(instance.getSubjects());
      this.withUserNames(instance.getUserNames());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterRoleBindingFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterRoleBinding build() {
    ClusterRoleBinding buildable = new ClusterRoleBinding(fluent.getApiVersion(),fluent.getGroupNames(),fluent.getKind(),fluent.buildMetadata(),fluent.buildRoleRef(),fluent.buildSubjects(),fluent.getUserNames());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}