package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ConfigMapBuildSourceFluent<A extends ConfigMapBuildSourceFluent<A>> extends BaseFluent<A>{
  public ConfigMapBuildSourceFluent() {
  }
  public ConfigMapBuildSourceFluent(ConfigMapBuildSource instance) {
    instance = (instance != null ? instance : new ConfigMapBuildSource());

    if (instance != null) {
      this.withConfigMap(instance.getConfigMap());
      this.withDestinationDir(instance.getDestinationDir());
      this.withConfigMap(instance.getConfigMap());
      this.withDestinationDir(instance.getDestinationDir());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private LocalObjectReferenceBuilder configMap;
  private String destinationDir;
  private Map<String,Object> additionalProperties;
  public LocalObjectReference buildConfigMap() {
    return this.configMap!=null ?this.configMap.build():null;
  }
  public A withConfigMap(LocalObjectReference configMap) {
    _visitables.get("configMap").remove(this.configMap);
    if (configMap!=null){ this.configMap= new LocalObjectReferenceBuilder(configMap); _visitables.get("configMap").add(this.configMap);} else { this.configMap = null; _visitables.get("configMap").remove(this.configMap); } return (A) this;
  }
  public boolean hasConfigMap() {
    return this.configMap != null;
  }
  public A withNewConfigMap(String name) {
    return (A)withConfigMap(new LocalObjectReference(name));
  }
  public ConfigMapNested<A> withNewConfigMap() {
    return new ConfigMapNested(null);
  }
  public ConfigMapNested<A> withNewConfigMapLike(LocalObjectReference item) {
    return new ConfigMapNested(item);
  }
  public ConfigMapNested<A> editConfigMap() {
    return withNewConfigMapLike(java.util.Optional.ofNullable(buildConfigMap()).orElse(null));
  }
  public ConfigMapNested<A> editOrNewConfigMap() {
    return withNewConfigMapLike(java.util.Optional.ofNullable(buildConfigMap()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  public ConfigMapNested<A> editOrNewConfigMapLike(LocalObjectReference item) {
    return withNewConfigMapLike(java.util.Optional.ofNullable(buildConfigMap()).orElse(item));
  }
  public String getDestinationDir() {
    return this.destinationDir;
  }
  public A withDestinationDir(String destinationDir) {
    this.destinationDir=destinationDir; return (A) this;
  }
  public boolean hasDestinationDir() {
    return this.destinationDir != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConfigMapBuildSourceFluent that = (ConfigMapBuildSourceFluent) o;
    if (!java.util.Objects.equals(configMap, that.configMap)) return false;

    if (!java.util.Objects.equals(destinationDir, that.destinationDir)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(configMap,  destinationDir,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (configMap != null) { sb.append("configMap:"); sb.append(configMap + ","); }
    if (destinationDir != null) { sb.append("destinationDir:"); sb.append(destinationDir + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ConfigMapNested<N> extends LocalObjectReferenceFluent<ConfigMapNested<N>> implements Nested<N>{
    ConfigMapNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) ConfigMapBuildSourceFluent.this.withConfigMap(builder.build());
    }
    public N endConfigMap() {
      return and();
    }
    
  }
  
}