package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentConditionBuilder extends DeploymentConditionFluent<DeploymentConditionBuilder> implements VisitableBuilder<DeploymentCondition,DeploymentConditionBuilder>{
  public DeploymentConditionBuilder() {
    this(false);
  }
  public DeploymentConditionBuilder(Boolean validationEnabled) {
    this(new DeploymentCondition(), validationEnabled);
  }
  public DeploymentConditionBuilder(DeploymentConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentConditionBuilder(DeploymentConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DeploymentCondition(), validationEnabled);
  }
  public DeploymentConditionBuilder(DeploymentConditionFluent<?> fluent,DeploymentCondition instance) {
    this(fluent, instance, false);
  }
  public DeploymentConditionBuilder(DeploymentConditionFluent<?> fluent,DeploymentCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DeploymentCondition());

    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withLastUpdateTime(instance.getLastUpdateTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withLastUpdateTime(instance.getLastUpdateTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DeploymentConditionBuilder(DeploymentCondition instance) {
    this(instance,false);
  }
  public DeploymentConditionBuilder(DeploymentCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DeploymentCondition());

    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withLastUpdateTime(instance.getLastUpdateTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withLastUpdateTime(instance.getLastUpdateTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DeploymentConditionFluent<?> fluent;
  Boolean validationEnabled;
  public DeploymentCondition build() {
    DeploymentCondition buildable = new DeploymentCondition(fluent.getLastTransitionTime(),fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}