package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DockerStrategyOptionsBuilder extends DockerStrategyOptionsFluent<DockerStrategyOptionsBuilder> implements VisitableBuilder<DockerStrategyOptions,DockerStrategyOptionsBuilder>{
  public DockerStrategyOptionsBuilder() {
    this(false);
  }
  public DockerStrategyOptionsBuilder(Boolean validationEnabled) {
    this(new DockerStrategyOptions(), validationEnabled);
  }
  public DockerStrategyOptionsBuilder(DockerStrategyOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public DockerStrategyOptionsBuilder(DockerStrategyOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DockerStrategyOptions(), validationEnabled);
  }
  public DockerStrategyOptionsBuilder(DockerStrategyOptionsFluent<?> fluent,DockerStrategyOptions instance) {
    this(fluent, instance, false);
  }
  public DockerStrategyOptionsBuilder(DockerStrategyOptionsFluent<?> fluent,DockerStrategyOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DockerStrategyOptions());

    if (instance != null) {
      fluent.withBuildArgs(instance.getBuildArgs());
      fluent.withNoCache(instance.getNoCache());
      fluent.withBuildArgs(instance.getBuildArgs());
      fluent.withNoCache(instance.getNoCache());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DockerStrategyOptionsBuilder(DockerStrategyOptions instance) {
    this(instance,false);
  }
  public DockerStrategyOptionsBuilder(DockerStrategyOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DockerStrategyOptions());

    if (instance != null) {
      this.withBuildArgs(instance.getBuildArgs());
      this.withNoCache(instance.getNoCache());
      this.withBuildArgs(instance.getBuildArgs());
      this.withNoCache(instance.getNoCache());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DockerStrategyOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public DockerStrategyOptions build() {
    DockerStrategyOptions buildable = new DockerStrategyOptions(fluent.getBuildArgs(),fluent.getNoCache());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}