package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageBuilder extends ImageFluent<ImageBuilder> implements VisitableBuilder<Image,ImageBuilder>{
  public ImageBuilder() {
    this(false);
  }
  public ImageBuilder(Boolean validationEnabled) {
    this(new Image(), validationEnabled);
  }
  public ImageBuilder(ImageFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageBuilder(ImageFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Image(), validationEnabled);
  }
  public ImageBuilder(ImageFluent<?> fluent,Image instance) {
    this(fluent, instance, false);
  }
  public ImageBuilder(ImageFluent<?> fluent,Image instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Image());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withDockerImageConfig(instance.getDockerImageConfig());
      fluent.withDockerImageLayers(instance.getDockerImageLayers());
      fluent.withDockerImageManifest(instance.getDockerImageManifest());
      fluent.withDockerImageManifestMediaType(instance.getDockerImageManifestMediaType());
      fluent.withDockerImageManifests(instance.getDockerImageManifests());
      fluent.withDockerImageMetadata(instance.getDockerImageMetadata());
      fluent.withDockerImageMetadataVersion(instance.getDockerImageMetadataVersion());
      fluent.withDockerImageReference(instance.getDockerImageReference());
      fluent.withDockerImageSignatures(instance.getDockerImageSignatures());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSignatures(instance.getSignatures());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withDockerImageConfig(instance.getDockerImageConfig());
      fluent.withDockerImageLayers(instance.getDockerImageLayers());
      fluent.withDockerImageManifest(instance.getDockerImageManifest());
      fluent.withDockerImageManifestMediaType(instance.getDockerImageManifestMediaType());
      fluent.withDockerImageManifests(instance.getDockerImageManifests());
      fluent.withDockerImageMetadata(instance.getDockerImageMetadata());
      fluent.withDockerImageMetadataVersion(instance.getDockerImageMetadataVersion());
      fluent.withDockerImageReference(instance.getDockerImageReference());
      fluent.withDockerImageSignatures(instance.getDockerImageSignatures());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSignatures(instance.getSignatures());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageBuilder(Image instance) {
    this(instance,false);
  }
  public ImageBuilder(Image instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Image());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withDockerImageConfig(instance.getDockerImageConfig());
      this.withDockerImageLayers(instance.getDockerImageLayers());
      this.withDockerImageManifest(instance.getDockerImageManifest());
      this.withDockerImageManifestMediaType(instance.getDockerImageManifestMediaType());
      this.withDockerImageManifests(instance.getDockerImageManifests());
      this.withDockerImageMetadata(instance.getDockerImageMetadata());
      this.withDockerImageMetadataVersion(instance.getDockerImageMetadataVersion());
      this.withDockerImageReference(instance.getDockerImageReference());
      this.withDockerImageSignatures(instance.getDockerImageSignatures());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSignatures(instance.getSignatures());
      this.withApiVersion(instance.getApiVersion());
      this.withDockerImageConfig(instance.getDockerImageConfig());
      this.withDockerImageLayers(instance.getDockerImageLayers());
      this.withDockerImageManifest(instance.getDockerImageManifest());
      this.withDockerImageManifestMediaType(instance.getDockerImageManifestMediaType());
      this.withDockerImageManifests(instance.getDockerImageManifests());
      this.withDockerImageMetadata(instance.getDockerImageMetadata());
      this.withDockerImageMetadataVersion(instance.getDockerImageMetadataVersion());
      this.withDockerImageReference(instance.getDockerImageReference());
      this.withDockerImageSignatures(instance.getDockerImageSignatures());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSignatures(instance.getSignatures());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageFluent<?> fluent;
  Boolean validationEnabled;
  public Image build() {
    Image buildable = new Image(fluent.getApiVersion(),fluent.getDockerImageConfig(),fluent.buildDockerImageLayers(),fluent.getDockerImageManifest(),fluent.getDockerImageManifestMediaType(),fluent.buildDockerImageManifests(),fluent.buildDockerImageMetadata(),fluent.getDockerImageMetadataVersion(),fluent.getDockerImageReference(),fluent.getDockerImageSignatures(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSignatures());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}