package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageTagBuilder extends ImageTagFluent<ImageTagBuilder> implements VisitableBuilder<ImageTag,ImageTagBuilder>{
  public ImageTagBuilder() {
    this(false);
  }
  public ImageTagBuilder(Boolean validationEnabled) {
    this(new ImageTag(), validationEnabled);
  }
  public ImageTagBuilder(ImageTagFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageTagBuilder(ImageTagFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageTag(), validationEnabled);
  }
  public ImageTagBuilder(ImageTagFluent<?> fluent,ImageTag instance) {
    this(fluent, instance, false);
  }
  public ImageTagBuilder(ImageTagFluent<?> fluent,ImageTag instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImageTag());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withImage(instance.getImage());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withImage(instance.getImage());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageTagBuilder(ImageTag instance) {
    this(instance,false);
  }
  public ImageTagBuilder(ImageTag instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImageTag());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withImage(instance.getImage());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withImage(instance.getImage());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageTagFluent<?> fluent;
  Boolean validationEnabled;
  public ImageTag build() {
    ImageTag buildable = new ImageTag(fluent.getApiVersion(),fluent.buildImage(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}