package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodSecurityPolicyReviewSpecBuilder extends PodSecurityPolicyReviewSpecFluent<PodSecurityPolicyReviewSpecBuilder> implements VisitableBuilder<PodSecurityPolicyReviewSpec,PodSecurityPolicyReviewSpecBuilder>{
  public PodSecurityPolicyReviewSpecBuilder() {
    this(false);
  }
  public PodSecurityPolicyReviewSpecBuilder(Boolean validationEnabled) {
    this(new PodSecurityPolicyReviewSpec(), validationEnabled);
  }
  public PodSecurityPolicyReviewSpecBuilder(PodSecurityPolicyReviewSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSecurityPolicyReviewSpecBuilder(PodSecurityPolicyReviewSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodSecurityPolicyReviewSpec(), validationEnabled);
  }
  public PodSecurityPolicyReviewSpecBuilder(PodSecurityPolicyReviewSpecFluent<?> fluent,PodSecurityPolicyReviewSpec instance) {
    this(fluent, instance, false);
  }
  public PodSecurityPolicyReviewSpecBuilder(PodSecurityPolicyReviewSpecFluent<?> fluent,PodSecurityPolicyReviewSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodSecurityPolicyReviewSpec());

    if (instance != null) {
      fluent.withServiceAccountNames(instance.getServiceAccountNames());
      fluent.withTemplate(instance.getTemplate());
      fluent.withServiceAccountNames(instance.getServiceAccountNames());
      fluent.withTemplate(instance.getTemplate());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodSecurityPolicyReviewSpecBuilder(PodSecurityPolicyReviewSpec instance) {
    this(instance,false);
  }
  public PodSecurityPolicyReviewSpecBuilder(PodSecurityPolicyReviewSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodSecurityPolicyReviewSpec());

    if (instance != null) {
      this.withServiceAccountNames(instance.getServiceAccountNames());
      this.withTemplate(instance.getTemplate());
      this.withServiceAccountNames(instance.getServiceAccountNames());
      this.withTemplate(instance.getTemplate());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodSecurityPolicyReviewSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PodSecurityPolicyReviewSpec build() {
    PodSecurityPolicyReviewSpec buildable = new PodSecurityPolicyReviewSpec(fluent.getServiceAccountNames(),fluent.buildTemplate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}