package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodSecurityPolicySubjectReviewSpecBuilder extends PodSecurityPolicySubjectReviewSpecFluent<PodSecurityPolicySubjectReviewSpecBuilder> implements VisitableBuilder<PodSecurityPolicySubjectReviewSpec,PodSecurityPolicySubjectReviewSpecBuilder>{
  public PodSecurityPolicySubjectReviewSpecBuilder() {
    this(false);
  }
  public PodSecurityPolicySubjectReviewSpecBuilder(Boolean validationEnabled) {
    this(new PodSecurityPolicySubjectReviewSpec(), validationEnabled);
  }
  public PodSecurityPolicySubjectReviewSpecBuilder(PodSecurityPolicySubjectReviewSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSecurityPolicySubjectReviewSpecBuilder(PodSecurityPolicySubjectReviewSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodSecurityPolicySubjectReviewSpec(), validationEnabled);
  }
  public PodSecurityPolicySubjectReviewSpecBuilder(PodSecurityPolicySubjectReviewSpecFluent<?> fluent,PodSecurityPolicySubjectReviewSpec instance) {
    this(fluent, instance, false);
  }
  public PodSecurityPolicySubjectReviewSpecBuilder(PodSecurityPolicySubjectReviewSpecFluent<?> fluent,PodSecurityPolicySubjectReviewSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodSecurityPolicySubjectReviewSpec());

    if (instance != null) {
      fluent.withGroups(instance.getGroups());
      fluent.withTemplate(instance.getTemplate());
      fluent.withUser(instance.getUser());
      fluent.withGroups(instance.getGroups());
      fluent.withTemplate(instance.getTemplate());
      fluent.withUser(instance.getUser());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodSecurityPolicySubjectReviewSpecBuilder(PodSecurityPolicySubjectReviewSpec instance) {
    this(instance,false);
  }
  public PodSecurityPolicySubjectReviewSpecBuilder(PodSecurityPolicySubjectReviewSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodSecurityPolicySubjectReviewSpec());

    if (instance != null) {
      this.withGroups(instance.getGroups());
      this.withTemplate(instance.getTemplate());
      this.withUser(instance.getUser());
      this.withGroups(instance.getGroups());
      this.withTemplate(instance.getTemplate());
      this.withUser(instance.getUser());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodSecurityPolicySubjectReviewSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PodSecurityPolicySubjectReviewSpec build() {
    PodSecurityPolicySubjectReviewSpec buildable = new PodSecurityPolicySubjectReviewSpec(fluent.getGroups(),fluent.buildTemplate(),fluent.getUser());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}