package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProjectBuilder extends ProjectFluent<ProjectBuilder> implements VisitableBuilder<Project,ProjectBuilder>{
  public ProjectBuilder() {
    this(false);
  }
  public ProjectBuilder(Boolean validationEnabled) {
    this(new Project(), validationEnabled);
  }
  public ProjectBuilder(ProjectFluent<?> fluent) {
    this(fluent, false);
  }
  public ProjectBuilder(ProjectFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Project(), validationEnabled);
  }
  public ProjectBuilder(ProjectFluent<?> fluent,Project instance) {
    this(fluent, instance, false);
  }
  public ProjectBuilder(ProjectFluent<?> fluent,Project instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Project());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ProjectBuilder(Project instance) {
    this(instance,false);
  }
  public ProjectBuilder(Project instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Project());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ProjectFluent<?> fluent;
  Boolean validationEnabled;
  public Project build() {
    Project buildable = new Project(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}