package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RepositoryImportStatusFluent<A extends RepositoryImportStatusFluent<A>> extends BaseFluent<A>{
  public RepositoryImportStatusFluent() {
  }
  public RepositoryImportStatusFluent(RepositoryImportStatus instance) {
    instance = (instance != null ? instance : new RepositoryImportStatus());

    if (instance != null) {
      this.withAdditionalTags(instance.getAdditionalTags());
      this.withImages(instance.getImages());
      this.withStatus(instance.getStatus());
      this.withAdditionalTags(instance.getAdditionalTags());
      this.withImages(instance.getImages());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<String> additionalTags = new ArrayList<String>();
  private ArrayList<ImageImportStatusBuilder> images = new ArrayList<ImageImportStatusBuilder>();
  private Status status;
  private Map<String,Object> additionalProperties;
  public A addToAdditionalTags(int index,String item) {
    if (this.additionalTags == null) {this.additionalTags = new ArrayList<String>();}
    this.additionalTags.add(index, item);
    return (A)this;
  }
  public A setToAdditionalTags(int index,String item) {
    if (this.additionalTags == null) {this.additionalTags = new ArrayList<String>();}
    this.additionalTags.set(index, item); return (A)this;
  }
  public A addToAdditionalTags(java.lang.String... items) {
    if (this.additionalTags == null) {this.additionalTags = new ArrayList<String>();}
    for (String item : items) {this.additionalTags.add(item);} return (A)this;
  }
  public A addAllToAdditionalTags(Collection<String> items) {
    if (this.additionalTags == null) {this.additionalTags = new ArrayList<String>();}
    for (String item : items) {this.additionalTags.add(item);} return (A)this;
  }
  public A removeFromAdditionalTags(java.lang.String... items) {
    if (this.additionalTags == null) return (A)this;
    for (String item : items) { this.additionalTags.remove(item);} return (A)this;
  }
  public A removeAllFromAdditionalTags(Collection<String> items) {
    if (this.additionalTags == null) return (A)this;
    for (String item : items) { this.additionalTags.remove(item);} return (A)this;
  }
  public List<String> getAdditionalTags() {
    return this.additionalTags;
  }
  public String getAdditionalTag(int index) {
    return this.additionalTags.get(index);
  }
  public String getFirstAdditionalTag() {
    return this.additionalTags.get(0);
  }
  public String getLastAdditionalTag() {
    return this.additionalTags.get(additionalTags.size() - 1);
  }
  public String getMatchingAdditionalTag(Predicate<String> predicate) {
    for (String item: additionalTags) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingAdditionalTag(Predicate<String> predicate) {
    for (String item: additionalTags) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAdditionalTags(List<String> additionalTags) {
    if (additionalTags != null) {this.additionalTags = new ArrayList(); for (String item : additionalTags){this.addToAdditionalTags(item);}} else { this.additionalTags = null;} return (A) this;
  }
  public A withAdditionalTags(java.lang.String... additionalTags) {
    if (this.additionalTags != null) {this.additionalTags.clear(); _visitables.remove("additionalTags"); }
    if (additionalTags != null) {for (String item :additionalTags){ this.addToAdditionalTags(item);}} return (A) this;
  }
  public boolean hasAdditionalTags() {
    return additionalTags != null && !additionalTags.isEmpty();
  }
  public A addToImages(int index,ImageImportStatus item) {
    if (this.images == null) {this.images = new ArrayList<ImageImportStatusBuilder>();}
    ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
    if (index < 0 || index >= images.size()) { _visitables.get("images").add(builder); images.add(builder); } else { _visitables.get("images").add(index, builder); images.add(index, builder);}
    return (A)this;
  }
  public A setToImages(int index,ImageImportStatus item) {
    if (this.images == null) {this.images = new ArrayList<ImageImportStatusBuilder>();}
    ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
    if (index < 0 || index >= images.size()) { _visitables.get("images").add(builder); images.add(builder); } else { _visitables.get("images").set(index, builder); images.set(index, builder);}
    return (A)this;
  }
  public A addToImages(io.fabric8.openshift.api.model.ImageImportStatus... items) {
    if (this.images == null) {this.images = new ArrayList<ImageImportStatusBuilder>();}
    for (ImageImportStatus item : items) {ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);_visitables.get("images").add(builder);this.images.add(builder);} return (A)this;
  }
  public A addAllToImages(Collection<ImageImportStatus> items) {
    if (this.images == null) {this.images = new ArrayList<ImageImportStatusBuilder>();}
    for (ImageImportStatus item : items) {ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);_visitables.get("images").add(builder);this.images.add(builder);} return (A)this;
  }
  public A removeFromImages(io.fabric8.openshift.api.model.ImageImportStatus... items) {
    if (this.images == null) return (A)this;
    for (ImageImportStatus item : items) {ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);_visitables.get("images").remove(builder); this.images.remove(builder);} return (A)this;
  }
  public A removeAllFromImages(Collection<ImageImportStatus> items) {
    if (this.images == null) return (A)this;
    for (ImageImportStatus item : items) {ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);_visitables.get("images").remove(builder); this.images.remove(builder);} return (A)this;
  }
  public A removeMatchingFromImages(Predicate<ImageImportStatusBuilder> predicate) {
    if (images == null) return (A) this;
    final Iterator<ImageImportStatusBuilder> each = images.iterator();
    final List visitables = _visitables.get("images");
    while (each.hasNext()) {
      ImageImportStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<ImageImportStatus> buildImages() {
    return images != null ? build(images) : null;
  }
  public ImageImportStatus buildImage(int index) {
    return this.images.get(index).build();
  }
  public ImageImportStatus buildFirstImage() {
    return this.images.get(0).build();
  }
  public ImageImportStatus buildLastImage() {
    return this.images.get(images.size() - 1).build();
  }
  public ImageImportStatus buildMatchingImage(Predicate<ImageImportStatusBuilder> predicate) {
    for (ImageImportStatusBuilder item: images) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingImage(Predicate<ImageImportStatusBuilder> predicate) {
    for (ImageImportStatusBuilder item: images) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withImages(List<ImageImportStatus> images) {
    if (this.images != null) { _visitables.get("images").clear();}
    if (images != null) {this.images = new ArrayList(); for (ImageImportStatus item : images){this.addToImages(item);}} else { this.images = null;} return (A) this;
  }
  public A withImages(io.fabric8.openshift.api.model.ImageImportStatus... images) {
    if (this.images != null) {this.images.clear(); _visitables.remove("images"); }
    if (images != null) {for (ImageImportStatus item :images){ this.addToImages(item);}} return (A) this;
  }
  public boolean hasImages() {
    return images != null && !images.isEmpty();
  }
  public ImagesNested<A> addNewImage() {
    return new ImagesNested(-1, null);
  }
  public ImagesNested<A> addNewImageLike(ImageImportStatus item) {
    return new ImagesNested(-1, item);
  }
  public ImagesNested<A> setNewImageLike(int index,ImageImportStatus item) {
    return new ImagesNested(index, item);
  }
  public ImagesNested<A> editImage(int index) {
    if (images.size() <= index) throw new RuntimeException("Can't edit images. Index exceeds size.");
    return setNewImageLike(index, buildImage(index));
  }
  public ImagesNested<A> editFirstImage() {
    if (images.size() == 0) throw new RuntimeException("Can't edit first images. The list is empty.");
    return setNewImageLike(0, buildImage(0));
  }
  public ImagesNested<A> editLastImage() {
    int index = images.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last images. The list is empty.");
    return setNewImageLike(index, buildImage(index));
  }
  public ImagesNested<A> editMatchingImage(Predicate<ImageImportStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<images.size();i++) { 
    if (predicate.test(images.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching images. No match found.");
    return setNewImageLike(index, buildImage(index));
  }
  public Status getStatus() {
    return this.status;
  }
  public A withStatus(Status status) {
    this.status=status; return (A) this;
  }
  public boolean hasStatus() {
    return this.status != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RepositoryImportStatusFluent that = (RepositoryImportStatusFluent) o;
    if (!java.util.Objects.equals(additionalTags, that.additionalTags)) return false;

    if (!java.util.Objects.equals(images, that.images)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(additionalTags,  images,  status,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalTags != null && !additionalTags.isEmpty()) { sb.append("additionalTags:"); sb.append(additionalTags + ","); }
    if (images != null && !images.isEmpty()) { sb.append("images:"); sb.append(images + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ImagesNested<N> extends ImageImportStatusFluent<ImagesNested<N>> implements Nested<N>{
    ImagesNested(int index,ImageImportStatus item) {
      this.index = index;
      this.builder = new ImageImportStatusBuilder(this, item);
    }
    ImageImportStatusBuilder builder;
    int index;
    public N and() {
      return (N) RepositoryImportStatusFluent.this.setToImages(index,builder.build());
    }
    public N endImage() {
      return and();
    }
    
  }
  
}