package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SELinuxContextStrategyOptionsBuilder extends SELinuxContextStrategyOptionsFluent<SELinuxContextStrategyOptionsBuilder> implements VisitableBuilder<SELinuxContextStrategyOptions,SELinuxContextStrategyOptionsBuilder>{
  public SELinuxContextStrategyOptionsBuilder() {
    this(false);
  }
  public SELinuxContextStrategyOptionsBuilder(Boolean validationEnabled) {
    this(new SELinuxContextStrategyOptions(), validationEnabled);
  }
  public SELinuxContextStrategyOptionsBuilder(SELinuxContextStrategyOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public SELinuxContextStrategyOptionsBuilder(SELinuxContextStrategyOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SELinuxContextStrategyOptions(), validationEnabled);
  }
  public SELinuxContextStrategyOptionsBuilder(SELinuxContextStrategyOptionsFluent<?> fluent,SELinuxContextStrategyOptions instance) {
    this(fluent, instance, false);
  }
  public SELinuxContextStrategyOptionsBuilder(SELinuxContextStrategyOptionsFluent<?> fluent,SELinuxContextStrategyOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SELinuxContextStrategyOptions());

    if (instance != null) {
      fluent.withSeLinuxOptions(instance.getSeLinuxOptions());
      fluent.withType(instance.getType());
      fluent.withSeLinuxOptions(instance.getSeLinuxOptions());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SELinuxContextStrategyOptionsBuilder(SELinuxContextStrategyOptions instance) {
    this(instance,false);
  }
  public SELinuxContextStrategyOptionsBuilder(SELinuxContextStrategyOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SELinuxContextStrategyOptions());

    if (instance != null) {
      this.withSeLinuxOptions(instance.getSeLinuxOptions());
      this.withType(instance.getType());
      this.withSeLinuxOptions(instance.getSeLinuxOptions());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SELinuxContextStrategyOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public SELinuxContextStrategyOptions build() {
    SELinuxContextStrategyOptions buildable = new SELinuxContextStrategyOptions(fluent.getSeLinuxOptions(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}