package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SecretBuildSourceFluent<A extends SecretBuildSourceFluent<A>> extends BaseFluent<A>{
  public SecretBuildSourceFluent() {
  }
  public SecretBuildSourceFluent(SecretBuildSource instance) {
    instance = (instance != null ? instance : new SecretBuildSource());

    if (instance != null) {
      this.withDestinationDir(instance.getDestinationDir());
      this.withSecret(instance.getSecret());
      this.withDestinationDir(instance.getDestinationDir());
      this.withSecret(instance.getSecret());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String destinationDir;
  private LocalObjectReferenceBuilder secret;
  private Map<String,Object> additionalProperties;
  public String getDestinationDir() {
    return this.destinationDir;
  }
  public A withDestinationDir(String destinationDir) {
    this.destinationDir=destinationDir; return (A) this;
  }
  public boolean hasDestinationDir() {
    return this.destinationDir != null;
  }
  public LocalObjectReference buildSecret() {
    return this.secret!=null ?this.secret.build():null;
  }
  public A withSecret(LocalObjectReference secret) {
    _visitables.get("secret").remove(this.secret);
    if (secret!=null){ this.secret= new LocalObjectReferenceBuilder(secret); _visitables.get("secret").add(this.secret);} else { this.secret = null; _visitables.get("secret").remove(this.secret); } return (A) this;
  }
  public boolean hasSecret() {
    return this.secret != null;
  }
  public A withNewSecret(String name) {
    return (A)withSecret(new LocalObjectReference(name));
  }
  public SecretNested<A> withNewSecret() {
    return new SecretNested(null);
  }
  public SecretNested<A> withNewSecretLike(LocalObjectReference item) {
    return new SecretNested(item);
  }
  public SecretNested<A> editSecret() {
    return withNewSecretLike(java.util.Optional.ofNullable(buildSecret()).orElse(null));
  }
  public SecretNested<A> editOrNewSecret() {
    return withNewSecretLike(java.util.Optional.ofNullable(buildSecret()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  public SecretNested<A> editOrNewSecretLike(LocalObjectReference item) {
    return withNewSecretLike(java.util.Optional.ofNullable(buildSecret()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SecretBuildSourceFluent that = (SecretBuildSourceFluent) o;
    if (!java.util.Objects.equals(destinationDir, that.destinationDir)) return false;

    if (!java.util.Objects.equals(secret, that.secret)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(destinationDir,  secret,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (destinationDir != null) { sb.append("destinationDir:"); sb.append(destinationDir + ","); }
    if (secret != null) { sb.append("secret:"); sb.append(secret + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class SecretNested<N> extends LocalObjectReferenceFluent<SecretNested<N>> implements Nested<N>{
    SecretNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) SecretBuildSourceFluent.this.withSecret(builder.build());
    }
    public N endSecret() {
      return and();
    }
    
  }
  
}