package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceAccountReferenceBuilder extends ServiceAccountReferenceFluent<ServiceAccountReferenceBuilder> implements VisitableBuilder<ServiceAccountReference,ServiceAccountReferenceBuilder>{
  public ServiceAccountReferenceBuilder() {
    this(false);
  }
  public ServiceAccountReferenceBuilder(Boolean validationEnabled) {
    this(new ServiceAccountReference(), validationEnabled);
  }
  public ServiceAccountReferenceBuilder(ServiceAccountReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceAccountReferenceBuilder(ServiceAccountReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceAccountReference(), validationEnabled);
  }
  public ServiceAccountReferenceBuilder(ServiceAccountReferenceFluent<?> fluent,ServiceAccountReference instance) {
    this(fluent, instance, false);
  }
  public ServiceAccountReferenceBuilder(ServiceAccountReferenceFluent<?> fluent,ServiceAccountReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ServiceAccountReference());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceAccountReferenceBuilder(ServiceAccountReference instance) {
    this(instance,false);
  }
  public ServiceAccountReferenceBuilder(ServiceAccountReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ServiceAccountReference());

    if (instance != null) {
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceAccountReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceAccountReference build() {
    ServiceAccountReference buildable = new ServiceAccountReference(fluent.getName(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}