package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceAccountRestrictionBuilder extends ServiceAccountRestrictionFluent<ServiceAccountRestrictionBuilder> implements VisitableBuilder<ServiceAccountRestriction,ServiceAccountRestrictionBuilder>{
  public ServiceAccountRestrictionBuilder() {
    this(false);
  }
  public ServiceAccountRestrictionBuilder(Boolean validationEnabled) {
    this(new ServiceAccountRestriction(), validationEnabled);
  }
  public ServiceAccountRestrictionBuilder(ServiceAccountRestrictionFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceAccountRestrictionBuilder(ServiceAccountRestrictionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceAccountRestriction(), validationEnabled);
  }
  public ServiceAccountRestrictionBuilder(ServiceAccountRestrictionFluent<?> fluent,ServiceAccountRestriction instance) {
    this(fluent, instance, false);
  }
  public ServiceAccountRestrictionBuilder(ServiceAccountRestrictionFluent<?> fluent,ServiceAccountRestriction instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ServiceAccountRestriction());

    if (instance != null) {
      fluent.withNamespaces(instance.getNamespaces());
      fluent.withServiceaccounts(instance.getServiceaccounts());
      fluent.withNamespaces(instance.getNamespaces());
      fluent.withServiceaccounts(instance.getServiceaccounts());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceAccountRestrictionBuilder(ServiceAccountRestriction instance) {
    this(instance,false);
  }
  public ServiceAccountRestrictionBuilder(ServiceAccountRestriction instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ServiceAccountRestriction());

    if (instance != null) {
      this.withNamespaces(instance.getNamespaces());
      this.withServiceaccounts(instance.getServiceaccounts());
      this.withNamespaces(instance.getNamespaces());
      this.withServiceaccounts(instance.getServiceaccounts());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceAccountRestrictionFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceAccountRestriction build() {
    ServiceAccountRestriction buildable = new ServiceAccountRestriction(fluent.getNamespaces(),fluent.buildServiceaccounts());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}