package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SignatureSubjectBuilder extends SignatureSubjectFluent<SignatureSubjectBuilder> implements VisitableBuilder<SignatureSubject,SignatureSubjectBuilder>{
  public SignatureSubjectBuilder() {
    this(false);
  }
  public SignatureSubjectBuilder(Boolean validationEnabled) {
    this(new SignatureSubject(), validationEnabled);
  }
  public SignatureSubjectBuilder(SignatureSubjectFluent<?> fluent) {
    this(fluent, false);
  }
  public SignatureSubjectBuilder(SignatureSubjectFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SignatureSubject(), validationEnabled);
  }
  public SignatureSubjectBuilder(SignatureSubjectFluent<?> fluent,SignatureSubject instance) {
    this(fluent, instance, false);
  }
  public SignatureSubjectBuilder(SignatureSubjectFluent<?> fluent,SignatureSubject instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SignatureSubject());

    if (instance != null) {
      fluent.withCommonName(instance.getCommonName());
      fluent.withOrganization(instance.getOrganization());
      fluent.withPublicKeyID(instance.getPublicKeyID());
      fluent.withCommonName(instance.getCommonName());
      fluent.withOrganization(instance.getOrganization());
      fluent.withPublicKeyID(instance.getPublicKeyID());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SignatureSubjectBuilder(SignatureSubject instance) {
    this(instance,false);
  }
  public SignatureSubjectBuilder(SignatureSubject instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SignatureSubject());

    if (instance != null) {
      this.withCommonName(instance.getCommonName());
      this.withOrganization(instance.getOrganization());
      this.withPublicKeyID(instance.getPublicKeyID());
      this.withCommonName(instance.getCommonName());
      this.withOrganization(instance.getOrganization());
      this.withPublicKeyID(instance.getPublicKeyID());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SignatureSubjectFluent<?> fluent;
  Boolean validationEnabled;
  public SignatureSubject build() {
    SignatureSubject buildable = new SignatureSubject(fluent.getCommonName(),fluent.getOrganization(),fluent.getPublicKeyID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}