package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SupplementalGroupsStrategyOptionsBuilder extends SupplementalGroupsStrategyOptionsFluent<SupplementalGroupsStrategyOptionsBuilder> implements VisitableBuilder<SupplementalGroupsStrategyOptions,SupplementalGroupsStrategyOptionsBuilder>{
  public SupplementalGroupsStrategyOptionsBuilder() {
    this(false);
  }
  public SupplementalGroupsStrategyOptionsBuilder(Boolean validationEnabled) {
    this(new SupplementalGroupsStrategyOptions(), validationEnabled);
  }
  public SupplementalGroupsStrategyOptionsBuilder(SupplementalGroupsStrategyOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public SupplementalGroupsStrategyOptionsBuilder(SupplementalGroupsStrategyOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SupplementalGroupsStrategyOptions(), validationEnabled);
  }
  public SupplementalGroupsStrategyOptionsBuilder(SupplementalGroupsStrategyOptionsFluent<?> fluent,SupplementalGroupsStrategyOptions instance) {
    this(fluent, instance, false);
  }
  public SupplementalGroupsStrategyOptionsBuilder(SupplementalGroupsStrategyOptionsFluent<?> fluent,SupplementalGroupsStrategyOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SupplementalGroupsStrategyOptions());

    if (instance != null) {
      fluent.withRanges(instance.getRanges());
      fluent.withType(instance.getType());
      fluent.withRanges(instance.getRanges());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SupplementalGroupsStrategyOptionsBuilder(SupplementalGroupsStrategyOptions instance) {
    this(instance,false);
  }
  public SupplementalGroupsStrategyOptionsBuilder(SupplementalGroupsStrategyOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SupplementalGroupsStrategyOptions());

    if (instance != null) {
      this.withRanges(instance.getRanges());
      this.withType(instance.getType());
      this.withRanges(instance.getRanges());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SupplementalGroupsStrategyOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public SupplementalGroupsStrategyOptions build() {
    SupplementalGroupsStrategyOptions buildable = new SupplementalGroupsStrategyOptions(fluent.buildRanges(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}