package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TagReferenceBuilder extends TagReferenceFluent<TagReferenceBuilder> implements VisitableBuilder<TagReference,TagReferenceBuilder>{
  public TagReferenceBuilder() {
    this(false);
  }
  public TagReferenceBuilder(Boolean validationEnabled) {
    this(new TagReference(), validationEnabled);
  }
  public TagReferenceBuilder(TagReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public TagReferenceBuilder(TagReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TagReference(), validationEnabled);
  }
  public TagReferenceBuilder(TagReferenceFluent<?> fluent,TagReference instance) {
    this(fluent, instance, false);
  }
  public TagReferenceBuilder(TagReferenceFluent<?> fluent,TagReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TagReference());

    if (instance != null) {
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withFrom(instance.getFrom());
      fluent.withGeneration(instance.getGeneration());
      fluent.withImportPolicy(instance.getImportPolicy());
      fluent.withName(instance.getName());
      fluent.withReference(instance.getReference());
      fluent.withReferencePolicy(instance.getReferencePolicy());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withFrom(instance.getFrom());
      fluent.withGeneration(instance.getGeneration());
      fluent.withImportPolicy(instance.getImportPolicy());
      fluent.withName(instance.getName());
      fluent.withReference(instance.getReference());
      fluent.withReferencePolicy(instance.getReferencePolicy());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TagReferenceBuilder(TagReference instance) {
    this(instance,false);
  }
  public TagReferenceBuilder(TagReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TagReference());

    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withFrom(instance.getFrom());
      this.withGeneration(instance.getGeneration());
      this.withImportPolicy(instance.getImportPolicy());
      this.withName(instance.getName());
      this.withReference(instance.getReference());
      this.withReferencePolicy(instance.getReferencePolicy());
      this.withAnnotations(instance.getAnnotations());
      this.withFrom(instance.getFrom());
      this.withGeneration(instance.getGeneration());
      this.withImportPolicy(instance.getImportPolicy());
      this.withName(instance.getName());
      this.withReference(instance.getReference());
      this.withReferencePolicy(instance.getReferencePolicy());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TagReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public TagReference build() {
    TagReference buildable = new TagReference(fluent.getAnnotations(),fluent.buildFrom(),fluent.getGeneration(),fluent.buildImportPolicy(),fluent.getName(),fluent.getReference(),fluent.buildReferencePolicy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}