package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TagReferencePolicyBuilder extends TagReferencePolicyFluent<TagReferencePolicyBuilder> implements VisitableBuilder<TagReferencePolicy,TagReferencePolicyBuilder>{
  public TagReferencePolicyBuilder() {
    this(false);
  }
  public TagReferencePolicyBuilder(Boolean validationEnabled) {
    this(new TagReferencePolicy(), validationEnabled);
  }
  public TagReferencePolicyBuilder(TagReferencePolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public TagReferencePolicyBuilder(TagReferencePolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TagReferencePolicy(), validationEnabled);
  }
  public TagReferencePolicyBuilder(TagReferencePolicyFluent<?> fluent,TagReferencePolicy instance) {
    this(fluent, instance, false);
  }
  public TagReferencePolicyBuilder(TagReferencePolicyFluent<?> fluent,TagReferencePolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TagReferencePolicy());

    if (instance != null) {
      fluent.withType(instance.getType());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TagReferencePolicyBuilder(TagReferencePolicy instance) {
    this(instance,false);
  }
  public TagReferencePolicyBuilder(TagReferencePolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TagReferencePolicy());

    if (instance != null) {
      this.withType(instance.getType());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TagReferencePolicyFluent<?> fluent;
  Boolean validationEnabled;
  public TagReferencePolicy build() {
    TagReferencePolicy buildable = new TagReferencePolicy(fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}