package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TemplateInstanceSpecBuilder extends TemplateInstanceSpecFluent<TemplateInstanceSpecBuilder> implements VisitableBuilder<TemplateInstanceSpec,TemplateInstanceSpecBuilder>{
  public TemplateInstanceSpecBuilder() {
    this(false);
  }
  public TemplateInstanceSpecBuilder(Boolean validationEnabled) {
    this(new TemplateInstanceSpec(), validationEnabled);
  }
  public TemplateInstanceSpecBuilder(TemplateInstanceSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public TemplateInstanceSpecBuilder(TemplateInstanceSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TemplateInstanceSpec(), validationEnabled);
  }
  public TemplateInstanceSpecBuilder(TemplateInstanceSpecFluent<?> fluent,TemplateInstanceSpec instance) {
    this(fluent, instance, false);
  }
  public TemplateInstanceSpecBuilder(TemplateInstanceSpecFluent<?> fluent,TemplateInstanceSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TemplateInstanceSpec());

    if (instance != null) {
      fluent.withRequester(instance.getRequester());
      fluent.withSecret(instance.getSecret());
      fluent.withTemplate(instance.getTemplate());
      fluent.withRequester(instance.getRequester());
      fluent.withSecret(instance.getSecret());
      fluent.withTemplate(instance.getTemplate());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TemplateInstanceSpecBuilder(TemplateInstanceSpec instance) {
    this(instance,false);
  }
  public TemplateInstanceSpecBuilder(TemplateInstanceSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TemplateInstanceSpec());

    if (instance != null) {
      this.withRequester(instance.getRequester());
      this.withSecret(instance.getSecret());
      this.withTemplate(instance.getTemplate());
      this.withRequester(instance.getRequester());
      this.withSecret(instance.getSecret());
      this.withTemplate(instance.getTemplate());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TemplateInstanceSpecFluent<?> fluent;
  Boolean validationEnabled;
  public TemplateInstanceSpec build() {
    TemplateInstanceSpec buildable = new TemplateInstanceSpec(fluent.buildRequester(),fluent.buildSecret(),fluent.buildTemplate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}