package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterNetworkBuilder extends ClusterNetworkFluent<ClusterNetworkBuilder> implements VisitableBuilder<ClusterNetwork,ClusterNetworkBuilder>{
  public ClusterNetworkBuilder() {
    this(new ClusterNetwork());
  }
  
  public ClusterNetworkBuilder(ClusterNetworkFluent<?> fluent) {
    this(fluent, new ClusterNetwork());
  }
  
  public ClusterNetworkBuilder(ClusterNetworkFluent<?> fluent,ClusterNetwork instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterNetworkBuilder(ClusterNetwork instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterNetworkFluent<?> fluent;
  
  public ClusterNetwork build() {
    ClusterNetwork buildable = new ClusterNetwork(fluent.getApiVersion(),fluent.buildClusterNetworks(),fluent.getHostsubnetlength(),fluent.getKind(),fluent.buildMetadata(),fluent.getMtu(),fluent.getNetwork(),fluent.getPluginName(),fluent.getServiceNetwork(),fluent.getVxlanPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}