package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterResourceQuotaSpecBuilder extends ClusterResourceQuotaSpecFluent<ClusterResourceQuotaSpecBuilder> implements VisitableBuilder<ClusterResourceQuotaSpec,ClusterResourceQuotaSpecBuilder>{
  public ClusterResourceQuotaSpecBuilder() {
    this(new ClusterResourceQuotaSpec());
  }
  
  public ClusterResourceQuotaSpecBuilder(ClusterResourceQuotaSpecFluent<?> fluent) {
    this(fluent, new ClusterResourceQuotaSpec());
  }
  
  public ClusterResourceQuotaSpecBuilder(ClusterResourceQuotaSpecFluent<?> fluent,ClusterResourceQuotaSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterResourceQuotaSpecBuilder(ClusterResourceQuotaSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterResourceQuotaSpecFluent<?> fluent;
  
  public ClusterResourceQuotaSpec build() {
    ClusterResourceQuotaSpec buildable = new ClusterResourceQuotaSpec(fluent.getQuota(),fluent.buildSelector());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}