package io.fabric8.openshift.api.model;

import io.fabric8.openshift.api.model.config.v1.SecretNameReference;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReference;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ConnectionConfigNamespaceScopedFluent<A extends ConnectionConfigNamespaceScopedFluent<A>> extends BaseFluent<A>{
  public ConnectionConfigNamespaceScopedFluent() {
  }
  
  public ConnectionConfigNamespaceScopedFluent(ConnectionConfigNamespaceScoped instance) {
    this.copyInstance(instance);
  }
  private SecretNameReference basicAuthConfig;
  private ConfigMapNameReference ca;
  private SecretNameReference tlsClientConfig;
  private String url;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ConnectionConfigNamespaceScoped instance) {
    instance = (instance != null ? instance : new ConnectionConfigNamespaceScoped());
  
    if (instance != null) {
        this.withBasicAuthConfig(instance.getBasicAuthConfig());
        this.withCa(instance.getCa());
        this.withTlsClientConfig(instance.getTlsClientConfig());
        this.withUrl(instance.getUrl());
        this.withBasicAuthConfig(instance.getBasicAuthConfig());
        this.withCa(instance.getCa());
        this.withTlsClientConfig(instance.getTlsClientConfig());
        this.withUrl(instance.getUrl());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public SecretNameReference getBasicAuthConfig() {
    return this.basicAuthConfig;
  }
  
  public A withBasicAuthConfig(SecretNameReference basicAuthConfig) {
    this.basicAuthConfig=basicAuthConfig; return (A) this;
  }
  
  public boolean hasBasicAuthConfig() {
    return this.basicAuthConfig != null;
  }
  
  public A withNewBasicAuthConfig(String name) {
    return (A)withBasicAuthConfig(new SecretNameReference(name));
  }
  
  public ConfigMapNameReference getCa() {
    return this.ca;
  }
  
  public A withCa(ConfigMapNameReference ca) {
    this.ca=ca; return (A) this;
  }
  
  public boolean hasCa() {
    return this.ca != null;
  }
  
  public A withNewCa(String name) {
    return (A)withCa(new ConfigMapNameReference(name));
  }
  
  public SecretNameReference getTlsClientConfig() {
    return this.tlsClientConfig;
  }
  
  public A withTlsClientConfig(SecretNameReference tlsClientConfig) {
    this.tlsClientConfig=tlsClientConfig; return (A) this;
  }
  
  public boolean hasTlsClientConfig() {
    return this.tlsClientConfig != null;
  }
  
  public A withNewTlsClientConfig(String name) {
    return (A)withTlsClientConfig(new SecretNameReference(name));
  }
  
  public String getUrl() {
    return this.url;
  }
  
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  
  public boolean hasUrl() {
    return this.url != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConnectionConfigNamespaceScopedFluent that = (ConnectionConfigNamespaceScopedFluent) o;
    if (!java.util.Objects.equals(basicAuthConfig, that.basicAuthConfig)) return false;
  
    if (!java.util.Objects.equals(ca, that.ca)) return false;
  
    if (!java.util.Objects.equals(tlsClientConfig, that.tlsClientConfig)) return false;
  
    if (!java.util.Objects.equals(url, that.url)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(basicAuthConfig,  ca,  tlsClientConfig,  url,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (basicAuthConfig != null) { sb.append("basicAuthConfig:"); sb.append(basicAuthConfig + ","); }
    if (ca != null) { sb.append("ca:"); sb.append(ca + ","); }
    if (tlsClientConfig != null) { sb.append("tlsClientConfig:"); sb.append(tlsClientConfig + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}