package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ImageListBuilder extends ImageListFluent<ImageListBuilder> implements VisitableBuilder<ImageList,ImageListBuilder>{
  public ImageListBuilder() {
    this(new ImageList());
  }
  
  public ImageListBuilder(ImageListFluent<?> fluent) {
    this(fluent, new ImageList());
  }
  
  public ImageListBuilder(ImageListFluent<?> fluent,ImageList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ImageListBuilder(ImageList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ImageListFluent<?> fluent;
  
  public ImageList build() {
    ImageList buildable = new ImageList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}