package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ImageStreamImportStatusFluent<A extends ImageStreamImportStatusFluent<A>> extends BaseFluent<A>{
  public ImageStreamImportStatusFluent() {
  }
  
  public ImageStreamImportStatusFluent(ImageStreamImportStatus instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ImageImportStatusBuilder> images = new ArrayList<ImageImportStatusBuilder>();
  private ImageStreamBuilder _import;
  private RepositoryImportStatusBuilder repository;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ImageStreamImportStatus instance) {
    instance = (instance != null ? instance : new ImageStreamImportStatus());
  
    if (instance != null) {
        this.withImages(instance.getImages());
        this.withImport(instance.getImport());
        this.withRepository(instance.getRepository());
        this.withImages(instance.getImages());
        this.withImport(instance.getImport());
        this.withRepository(instance.getRepository());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public A addToImages(int index,ImageImportStatus item) {
    if (this.images == null) {this.images = new ArrayList<ImageImportStatusBuilder>();}
    ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
    if (index < 0 || index >= images.size()) { _visitables.get("images").add(builder); images.add(builder); } else { _visitables.get("images").add(index, builder); images.add(index, builder);}
    return (A)this;
  }
  
  public A setToImages(int index,ImageImportStatus item) {
    if (this.images == null) {this.images = new ArrayList<ImageImportStatusBuilder>();}
    ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
    if (index < 0 || index >= images.size()) { _visitables.get("images").add(builder); images.add(builder); } else { _visitables.get("images").set(index, builder); images.set(index, builder);}
    return (A)this;
  }
  
  public A addToImages(io.fabric8.openshift.api.model.ImageImportStatus... items) {
    if (this.images == null) {this.images = new ArrayList<ImageImportStatusBuilder>();}
    for (ImageImportStatus item : items) {ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);_visitables.get("images").add(builder);this.images.add(builder);} return (A)this;
  }
  
  public A addAllToImages(Collection<ImageImportStatus> items) {
    if (this.images == null) {this.images = new ArrayList<ImageImportStatusBuilder>();}
    for (ImageImportStatus item : items) {ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);_visitables.get("images").add(builder);this.images.add(builder);} return (A)this;
  }
  
  public A removeFromImages(io.fabric8.openshift.api.model.ImageImportStatus... items) {
    if (this.images == null) return (A)this;
    for (ImageImportStatus item : items) {ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);_visitables.get("images").remove(builder); this.images.remove(builder);} return (A)this;
  }
  
  public A removeAllFromImages(Collection<ImageImportStatus> items) {
    if (this.images == null) return (A)this;
    for (ImageImportStatus item : items) {ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);_visitables.get("images").remove(builder); this.images.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromImages(Predicate<ImageImportStatusBuilder> predicate) {
    if (images == null) return (A) this;
    final Iterator<ImageImportStatusBuilder> each = images.iterator();
    final List visitables = _visitables.get("images");
    while (each.hasNext()) {
      ImageImportStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ImageImportStatus> buildImages() {
    return images != null ? build(images) : null;
  }
  
  public ImageImportStatus buildImage(int index) {
    return this.images.get(index).build();
  }
  
  public ImageImportStatus buildFirstImage() {
    return this.images.get(0).build();
  }
  
  public ImageImportStatus buildLastImage() {
    return this.images.get(images.size() - 1).build();
  }
  
  public ImageImportStatus buildMatchingImage(Predicate<ImageImportStatusBuilder> predicate) {
    for (ImageImportStatusBuilder item: images) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingImage(Predicate<ImageImportStatusBuilder> predicate) {
    for (ImageImportStatusBuilder item: images) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withImages(List<ImageImportStatus> images) {
    if (this.images != null) { _visitables.get("images").clear();}
    if (images != null) {this.images = new ArrayList(); for (ImageImportStatus item : images){this.addToImages(item);}} else { this.images = null;} return (A) this;
  }
  
  public A withImages(io.fabric8.openshift.api.model.ImageImportStatus... images) {
    if (this.images != null) {this.images.clear(); _visitables.remove("images"); }
    if (images != null) {for (ImageImportStatus item :images){ this.addToImages(item);}} return (A) this;
  }
  
  public boolean hasImages() {
    return images != null && !images.isEmpty();
  }
  
  public ImagesNested<A> addNewImage() {
    return new ImagesNested(-1, null);
  }
  
  public ImagesNested<A> addNewImageLike(ImageImportStatus item) {
    return new ImagesNested(-1, item);
  }
  
  public ImagesNested<A> setNewImageLike(int index,ImageImportStatus item) {
    return new ImagesNested(index, item);
  }
  
  public ImagesNested<A> editImage(int index) {
    if (images.size() <= index) throw new RuntimeException("Can't edit images. Index exceeds size.");
    return setNewImageLike(index, buildImage(index));
  }
  
  public ImagesNested<A> editFirstImage() {
    if (images.size() == 0) throw new RuntimeException("Can't edit first images. The list is empty.");
    return setNewImageLike(0, buildImage(0));
  }
  
  public ImagesNested<A> editLastImage() {
    int index = images.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last images. The list is empty.");
    return setNewImageLike(index, buildImage(index));
  }
  
  public ImagesNested<A> editMatchingImage(Predicate<ImageImportStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<images.size();i++) { 
    if (predicate.test(images.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching images. No match found.");
    return setNewImageLike(index, buildImage(index));
  }
  
  public ImageStream buildImport() {
    return this._import!=null ?this._import.build():null;
  }
  
  public A withImport(ImageStream _import) {
    _visitables.get("_import").remove(this._import);
    if (_import!=null){ this._import= new ImageStreamBuilder(_import); _visitables.get("_import").add(this._import);} else { this._import = null; _visitables.get("_import").remove(this._import); } return (A) this;
  }
  
  public boolean hasImport() {
    return this._import != null;
  }
  
  public ImportNested<A> withNewImport() {
    return new ImportNested(null);
  }
  
  public ImportNested<A> withNewImportLike(ImageStream item) {
    return new ImportNested(item);
  }
  
  public ImportNested<A> editImport() {
    return withNewImportLike(java.util.Optional.ofNullable(buildImport()).orElse(null));
  }
  
  public ImportNested<A> editOrNewImport() {
    return withNewImportLike(java.util.Optional.ofNullable(buildImport()).orElse(new ImageStreamBuilder().build()));
  }
  
  public ImportNested<A> editOrNewImportLike(ImageStream item) {
    return withNewImportLike(java.util.Optional.ofNullable(buildImport()).orElse(item));
  }
  
  public RepositoryImportStatus buildRepository() {
    return this.repository!=null ?this.repository.build():null;
  }
  
  public A withRepository(RepositoryImportStatus repository) {
    _visitables.get("repository").remove(this.repository);
    if (repository!=null){ this.repository= new RepositoryImportStatusBuilder(repository); _visitables.get("repository").add(this.repository);} else { this.repository = null; _visitables.get("repository").remove(this.repository); } return (A) this;
  }
  
  public boolean hasRepository() {
    return this.repository != null;
  }
  
  public RepositoryNested<A> withNewRepository() {
    return new RepositoryNested(null);
  }
  
  public RepositoryNested<A> withNewRepositoryLike(RepositoryImportStatus item) {
    return new RepositoryNested(item);
  }
  
  public RepositoryNested<A> editRepository() {
    return withNewRepositoryLike(java.util.Optional.ofNullable(buildRepository()).orElse(null));
  }
  
  public RepositoryNested<A> editOrNewRepository() {
    return withNewRepositoryLike(java.util.Optional.ofNullable(buildRepository()).orElse(new RepositoryImportStatusBuilder().build()));
  }
  
  public RepositoryNested<A> editOrNewRepositoryLike(RepositoryImportStatus item) {
    return withNewRepositoryLike(java.util.Optional.ofNullable(buildRepository()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ImageStreamImportStatusFluent that = (ImageStreamImportStatusFluent) o;
    if (!java.util.Objects.equals(images, that.images)) return false;
  
    if (!java.util.Objects.equals(_import, that._import)) return false;
  
    if (!java.util.Objects.equals(repository, that.repository)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(images,  _import,  repository,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (images != null && !images.isEmpty()) { sb.append("images:"); sb.append(images + ","); }
    if (_import != null) { sb.append("_import:"); sb.append(_import + ","); }
    if (repository != null) { sb.append("repository:"); sb.append(repository + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ImagesNested<N> extends ImageImportStatusFluent<ImagesNested<N>> implements Nested<N>{
    ImagesNested(int index,ImageImportStatus item) {
      this.index = index;
      this.builder = new ImageImportStatusBuilder(this, item);
    }
    ImageImportStatusBuilder builder;
    int index;
    
    public N and() {
      return (N) ImageStreamImportStatusFluent.this.setToImages(index,builder.build());
    }
    
    public N endImage() {
      return and();
    }
    
  
  }
  public class ImportNested<N> extends ImageStreamFluent<ImportNested<N>> implements Nested<N>{
    ImportNested(ImageStream item) {
      this.builder = new ImageStreamBuilder(this, item);
    }
    ImageStreamBuilder builder;
    
    public N and() {
      return (N) ImageStreamImportStatusFluent.this.withImport(builder.build());
    }
    
    public N endImport() {
      return and();
    }
    
  
  }
  public class RepositoryNested<N> extends RepositoryImportStatusFluent<RepositoryNested<N>> implements Nested<N>{
    RepositoryNested(RepositoryImportStatus item) {
      this.builder = new RepositoryImportStatusBuilder(this, item);
    }
    RepositoryImportStatusBuilder builder;
    
    public N and() {
      return (N) ImageStreamImportStatusFluent.this.withRepository(builder.build());
    }
    
    public N endRepository() {
      return and();
    }
    
  
  }

}