package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TemplateInstanceSpecFluent<A extends TemplateInstanceSpecFluent<A>> extends BaseFluent<A>{
  public TemplateInstanceSpecFluent() {
  }
  
  public TemplateInstanceSpecFluent(TemplateInstanceSpec instance) {
    this.copyInstance(instance);
  }
  private TemplateInstanceRequesterBuilder requester;
  private LocalObjectReferenceBuilder secret;
  private TemplateBuilder template;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TemplateInstanceSpec instance) {
    instance = (instance != null ? instance : new TemplateInstanceSpec());
  
    if (instance != null) {
        this.withRequester(instance.getRequester());
        this.withSecret(instance.getSecret());
        this.withTemplate(instance.getTemplate());
        this.withRequester(instance.getRequester());
        this.withSecret(instance.getSecret());
        this.withTemplate(instance.getTemplate());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public TemplateInstanceRequester buildRequester() {
    return this.requester!=null ?this.requester.build():null;
  }
  
  public A withRequester(TemplateInstanceRequester requester) {
    _visitables.get("requester").remove(this.requester);
    if (requester!=null){ this.requester= new TemplateInstanceRequesterBuilder(requester); _visitables.get("requester").add(this.requester);} else { this.requester = null; _visitables.get("requester").remove(this.requester); } return (A) this;
  }
  
  public boolean hasRequester() {
    return this.requester != null;
  }
  
  public RequesterNested<A> withNewRequester() {
    return new RequesterNested(null);
  }
  
  public RequesterNested<A> withNewRequesterLike(TemplateInstanceRequester item) {
    return new RequesterNested(item);
  }
  
  public RequesterNested<A> editRequester() {
    return withNewRequesterLike(java.util.Optional.ofNullable(buildRequester()).orElse(null));
  }
  
  public RequesterNested<A> editOrNewRequester() {
    return withNewRequesterLike(java.util.Optional.ofNullable(buildRequester()).orElse(new TemplateInstanceRequesterBuilder().build()));
  }
  
  public RequesterNested<A> editOrNewRequesterLike(TemplateInstanceRequester item) {
    return withNewRequesterLike(java.util.Optional.ofNullable(buildRequester()).orElse(item));
  }
  
  public LocalObjectReference buildSecret() {
    return this.secret!=null ?this.secret.build():null;
  }
  
  public A withSecret(LocalObjectReference secret) {
    _visitables.get("secret").remove(this.secret);
    if (secret!=null){ this.secret= new LocalObjectReferenceBuilder(secret); _visitables.get("secret").add(this.secret);} else { this.secret = null; _visitables.get("secret").remove(this.secret); } return (A) this;
  }
  
  public boolean hasSecret() {
    return this.secret != null;
  }
  
  public A withNewSecret(String name) {
    return (A)withSecret(new LocalObjectReference(name));
  }
  
  public SecretNested<A> withNewSecret() {
    return new SecretNested(null);
  }
  
  public SecretNested<A> withNewSecretLike(LocalObjectReference item) {
    return new SecretNested(item);
  }
  
  public SecretNested<A> editSecret() {
    return withNewSecretLike(java.util.Optional.ofNullable(buildSecret()).orElse(null));
  }
  
  public SecretNested<A> editOrNewSecret() {
    return withNewSecretLike(java.util.Optional.ofNullable(buildSecret()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  
  public SecretNested<A> editOrNewSecretLike(LocalObjectReference item) {
    return withNewSecretLike(java.util.Optional.ofNullable(buildSecret()).orElse(item));
  }
  
  public Template buildTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  
  public A withTemplate(Template template) {
    _visitables.get("template").remove(this.template);
    if (template!=null){ this.template= new TemplateBuilder(template); _visitables.get("template").add(this.template);} else { this.template = null; _visitables.get("template").remove(this.template); } return (A) this;
  }
  
  public boolean hasTemplate() {
    return this.template != null;
  }
  
  public TemplateNested<A> withNewTemplate() {
    return new TemplateNested(null);
  }
  
  public TemplateNested<A> withNewTemplateLike(Template item) {
    return new TemplateNested(item);
  }
  
  public TemplateNested<A> editTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(null));
  }
  
  public TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(new TemplateBuilder().build()));
  }
  
  public TemplateNested<A> editOrNewTemplateLike(Template item) {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TemplateInstanceSpecFluent that = (TemplateInstanceSpecFluent) o;
    if (!java.util.Objects.equals(requester, that.requester)) return false;
  
    if (!java.util.Objects.equals(secret, that.secret)) return false;
  
    if (!java.util.Objects.equals(template, that.template)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(requester,  secret,  template,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (requester != null) { sb.append("requester:"); sb.append(requester + ","); }
    if (secret != null) { sb.append("secret:"); sb.append(secret + ","); }
    if (template != null) { sb.append("template:"); sb.append(template + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class RequesterNested<N> extends TemplateInstanceRequesterFluent<RequesterNested<N>> implements Nested<N>{
    RequesterNested(TemplateInstanceRequester item) {
      this.builder = new TemplateInstanceRequesterBuilder(this, item);
    }
    TemplateInstanceRequesterBuilder builder;
    
    public N and() {
      return (N) TemplateInstanceSpecFluent.this.withRequester(builder.build());
    }
    
    public N endRequester() {
      return and();
    }
    
  
  }
  public class SecretNested<N> extends LocalObjectReferenceFluent<SecretNested<N>> implements Nested<N>{
    SecretNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) TemplateInstanceSpecFluent.this.withSecret(builder.build());
    }
    
    public N endSecret() {
      return and();
    }
    
  
  }
  public class TemplateNested<N> extends TemplateFluent<TemplateNested<N>> implements Nested<N>{
    TemplateNested(Template item) {
      this.builder = new TemplateBuilder(this, item);
    }
    TemplateBuilder builder;
    
    public N and() {
      return (N) TemplateInstanceSpecFluent.this.withTemplate(builder.build());
    }
    
    public N endTemplate() {
      return and();
    }
    
  
  }

}