/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.ImageImportSpec;
import io.fabric8.openshift.api.model.ImageImportSpecBuilder;
import io.fabric8.openshift.api.model.ImageImportSpecFluent;
import io.fabric8.openshift.api.model.ImageStreamImportSpec;
import io.fabric8.openshift.api.model.RepositoryImportSpec;
import io.fabric8.openshift.api.model.RepositoryImportSpecBuilder;
import io.fabric8.openshift.api.model.RepositoryImportSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ImageStreamImportSpecFluent<A extends ImageStreamImportSpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ImageImportSpecBuilder> images = new ArrayList();
    private Boolean _import;
    private RepositoryImportSpecBuilder repository;
    private Map<String, Object> additionalProperties;

    public ImageStreamImportSpecFluent() {
    }

    public ImageStreamImportSpecFluent(ImageStreamImportSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ImageStreamImportSpec instance) {
        ImageStreamImportSpec imageStreamImportSpec = instance = instance != null ? instance : new ImageStreamImportSpec();
        if (instance != null) {
            this.withImages(instance.getImages());
            this.withImport(instance.getImport());
            this.withRepository(instance.getRepository());
            this.withImages(instance.getImages());
            this.withImport(instance.getImport());
            this.withRepository(instance.getRepository());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToImages(int index, ImageImportSpec item) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        ImageImportSpecBuilder builder = new ImageImportSpecBuilder(item);
        if (index < 0 || index >= this.images.size()) {
            this._visitables.get((Object)"images").add(builder);
            this.images.add(builder);
        } else {
            this._visitables.get((Object)"images").add(index, builder);
            this.images.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToImages(int index, ImageImportSpec item) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        ImageImportSpecBuilder builder = new ImageImportSpecBuilder(item);
        if (index < 0 || index >= this.images.size()) {
            this._visitables.get((Object)"images").add(builder);
            this.images.add(builder);
        } else {
            this._visitables.get((Object)"images").set(index, builder);
            this.images.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToImages(ImageImportSpec ... items) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        for (ImageImportSpec item : items) {
            ImageImportSpecBuilder builder = new ImageImportSpecBuilder(item);
            this._visitables.get((Object)"images").add(builder);
            this.images.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToImages(Collection<ImageImportSpec> items) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        for (ImageImportSpec item : items) {
            ImageImportSpecBuilder builder = new ImageImportSpecBuilder(item);
            this._visitables.get((Object)"images").add(builder);
            this.images.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromImages(ImageImportSpec ... items) {
        if (this.images == null) {
            return (A)((Object)this);
        }
        for (ImageImportSpec item : items) {
            ImageImportSpecBuilder builder = new ImageImportSpecBuilder(item);
            this._visitables.get((Object)"images").remove((Object)builder);
            this.images.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromImages(Collection<ImageImportSpec> items) {
        if (this.images == null) {
            return (A)((Object)this);
        }
        for (ImageImportSpec item : items) {
            ImageImportSpecBuilder builder = new ImageImportSpecBuilder(item);
            this._visitables.get((Object)"images").remove((Object)builder);
            this.images.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromImages(Predicate<ImageImportSpecBuilder> predicate) {
        if (this.images == null) {
            return (A)((Object)this);
        }
        Iterator<ImageImportSpecBuilder> each = this.images.iterator();
        List visitables = this._visitables.get((Object)"images");
        while (each.hasNext()) {
            ImageImportSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ImageImportSpec> buildImages() {
        return this.images != null ? ImageStreamImportSpecFluent.build(this.images) : null;
    }

    public ImageImportSpec buildImage(int index) {
        return this.images.get(index).build();
    }

    public ImageImportSpec buildFirstImage() {
        return this.images.get(0).build();
    }

    public ImageImportSpec buildLastImage() {
        return this.images.get(this.images.size() - 1).build();
    }

    public ImageImportSpec buildMatchingImage(Predicate<ImageImportSpecBuilder> predicate) {
        for (ImageImportSpecBuilder item : this.images) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingImage(Predicate<ImageImportSpecBuilder> predicate) {
        for (ImageImportSpecBuilder item : this.images) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withImages(List<ImageImportSpec> images) {
        if (this.images != null) {
            this._visitables.get((Object)"images").clear();
        }
        if (images != null) {
            this.images = new ArrayList();
            for (ImageImportSpec item : images) {
                this.addToImages(item);
            }
        } else {
            this.images = null;
        }
        return (A)((Object)this);
    }

    public A withImages(ImageImportSpec ... images) {
        if (this.images != null) {
            this.images.clear();
            this._visitables.remove((Object)"images");
        }
        if (images != null) {
            for (ImageImportSpec item : images) {
                this.addToImages(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasImages() {
        return this.images != null && !this.images.isEmpty();
    }

    public ImagesNested<A> addNewImage() {
        return new ImagesNested(-1, null);
    }

    public ImagesNested<A> addNewImageLike(ImageImportSpec item) {
        return new ImagesNested(-1, item);
    }

    public ImagesNested<A> setNewImageLike(int index, ImageImportSpec item) {
        return new ImagesNested(index, item);
    }

    public ImagesNested<A> editImage(int index) {
        if (this.images.size() <= index) {
            throw new RuntimeException("Can't edit images. Index exceeds size.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    public ImagesNested<A> editFirstImage() {
        if (this.images.size() == 0) {
            throw new RuntimeException("Can't edit first images. The list is empty.");
        }
        return this.setNewImageLike(0, this.buildImage(0));
    }

    public ImagesNested<A> editLastImage() {
        int index = this.images.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last images. The list is empty.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    public ImagesNested<A> editMatchingImage(Predicate<ImageImportSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.images.size(); ++i) {
            if (!predicate.test(this.images.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching images. No match found.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    public Boolean getImport() {
        return this._import;
    }

    public A withImport(Boolean _import) {
        this._import = _import;
        return (A)((Object)this);
    }

    public boolean hasImport() {
        return this._import != null;
    }

    public RepositoryImportSpec buildRepository() {
        return this.repository != null ? this.repository.build() : null;
    }

    public A withRepository(RepositoryImportSpec repository) {
        this._visitables.get((Object)"repository").remove((Object)this.repository);
        if (repository != null) {
            this.repository = new RepositoryImportSpecBuilder(repository);
            this._visitables.get((Object)"repository").add(this.repository);
        } else {
            this.repository = null;
            this._visitables.get((Object)"repository").remove((Object)this.repository);
        }
        return (A)((Object)this);
    }

    public boolean hasRepository() {
        return this.repository != null;
    }

    public RepositoryNested<A> withNewRepository() {
        return new RepositoryNested(null);
    }

    public RepositoryNested<A> withNewRepositoryLike(RepositoryImportSpec item) {
        return new RepositoryNested(item);
    }

    public RepositoryNested<A> editRepository() {
        return this.withNewRepositoryLike(Optional.ofNullable(this.buildRepository()).orElse(null));
    }

    public RepositoryNested<A> editOrNewRepository() {
        return this.withNewRepositoryLike(Optional.ofNullable(this.buildRepository()).orElse(new RepositoryImportSpecBuilder().build()));
    }

    public RepositoryNested<A> editOrNewRepositoryLike(RepositoryImportSpec item) {
        return this.withNewRepositoryLike(Optional.ofNullable(this.buildRepository()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageStreamImportSpecFluent that = (ImageStreamImportSpecFluent)((Object)o);
        if (!Objects.equals(this.images, that.images)) {
            return false;
        }
        if (!Objects.equals(this._import, that._import)) {
            return false;
        }
        if (!Objects.equals((Object)this.repository, (Object)that.repository)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.images, this._import, this.repository, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.images != null && !this.images.isEmpty()) {
            sb.append("images:");
            sb.append(this.images + ",");
        }
        if (this._import != null) {
            sb.append("_import:");
            sb.append(this._import + ",");
        }
        if (this.repository != null) {
            sb.append("repository:");
            sb.append((Object)((Object)this.repository) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withImport() {
        return this.withImport(true);
    }

    public class RepositoryNested<N>
    extends RepositoryImportSpecFluent<RepositoryNested<N>>
    implements Nested<N> {
        RepositoryImportSpecBuilder builder;

        RepositoryNested(RepositoryImportSpec item) {
            this.builder = new RepositoryImportSpecBuilder(this, item);
        }

        public N and() {
            return (N)ImageStreamImportSpecFluent.this.withRepository(this.builder.build());
        }

        public N endRepository() {
            return this.and();
        }
    }

    public class ImagesNested<N>
    extends ImageImportSpecFluent<ImagesNested<N>>
    implements Nested<N> {
        ImageImportSpecBuilder builder;
        int index;

        ImagesNested(int index, ImageImportSpec item) {
            this.index = index;
            this.builder = new ImageImportSpecBuilder(this, item);
        }

        public N and() {
            return (N)ImageStreamImportSpecFluent.this.setToImages(this.index, this.builder.build());
        }

        public N endImage() {
            return this.and();
        }
    }
}

