/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.ImageLookupPolicy;
import io.fabric8.openshift.api.model.ImageLookupPolicyBuilder;
import io.fabric8.openshift.api.model.ImageLookupPolicyFluent;
import io.fabric8.openshift.api.model.ImageStreamSpec;
import io.fabric8.openshift.api.model.TagReference;
import io.fabric8.openshift.api.model.TagReferenceBuilder;
import io.fabric8.openshift.api.model.TagReferenceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ImageStreamSpecFluent<A extends ImageStreamSpecFluent<A>>
extends BaseFluent<A> {
    private String dockerImageRepository;
    private ImageLookupPolicyBuilder lookupPolicy;
    private ArrayList<TagReferenceBuilder> tags = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ImageStreamSpecFluent() {
    }

    public ImageStreamSpecFluent(ImageStreamSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ImageStreamSpec instance) {
        ImageStreamSpec imageStreamSpec = instance = instance != null ? instance : new ImageStreamSpec();
        if (instance != null) {
            this.withDockerImageRepository(instance.getDockerImageRepository());
            this.withLookupPolicy(instance.getLookupPolicy());
            this.withTags(instance.getTags());
            this.withDockerImageRepository(instance.getDockerImageRepository());
            this.withLookupPolicy(instance.getLookupPolicy());
            this.withTags(instance.getTags());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getDockerImageRepository() {
        return this.dockerImageRepository;
    }

    public A withDockerImageRepository(String dockerImageRepository) {
        this.dockerImageRepository = dockerImageRepository;
        return (A)((Object)this);
    }

    public boolean hasDockerImageRepository() {
        return this.dockerImageRepository != null;
    }

    public ImageLookupPolicy buildLookupPolicy() {
        return this.lookupPolicy != null ? this.lookupPolicy.build() : null;
    }

    public A withLookupPolicy(ImageLookupPolicy lookupPolicy) {
        this._visitables.get((Object)"lookupPolicy").remove((Object)this.lookupPolicy);
        if (lookupPolicy != null) {
            this.lookupPolicy = new ImageLookupPolicyBuilder(lookupPolicy);
            this._visitables.get((Object)"lookupPolicy").add(this.lookupPolicy);
        } else {
            this.lookupPolicy = null;
            this._visitables.get((Object)"lookupPolicy").remove((Object)this.lookupPolicy);
        }
        return (A)((Object)this);
    }

    public boolean hasLookupPolicy() {
        return this.lookupPolicy != null;
    }

    public A withNewLookupPolicy(Boolean local) {
        return this.withLookupPolicy(new ImageLookupPolicy(local));
    }

    public LookupPolicyNested<A> withNewLookupPolicy() {
        return new LookupPolicyNested(null);
    }

    public LookupPolicyNested<A> withNewLookupPolicyLike(ImageLookupPolicy item) {
        return new LookupPolicyNested(item);
    }

    public LookupPolicyNested<A> editLookupPolicy() {
        return this.withNewLookupPolicyLike(Optional.ofNullable(this.buildLookupPolicy()).orElse(null));
    }

    public LookupPolicyNested<A> editOrNewLookupPolicy() {
        return this.withNewLookupPolicyLike(Optional.ofNullable(this.buildLookupPolicy()).orElse(new ImageLookupPolicyBuilder().build()));
    }

    public LookupPolicyNested<A> editOrNewLookupPolicyLike(ImageLookupPolicy item) {
        return this.withNewLookupPolicyLike(Optional.ofNullable(this.buildLookupPolicy()).orElse(item));
    }

    public A addToTags(int index, TagReference item) {
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        TagReferenceBuilder builder = new TagReferenceBuilder(item);
        if (index < 0 || index >= this.tags.size()) {
            this._visitables.get((Object)"tags").add(builder);
            this.tags.add(builder);
        } else {
            this._visitables.get((Object)"tags").add(index, builder);
            this.tags.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTags(int index, TagReference item) {
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        TagReferenceBuilder builder = new TagReferenceBuilder(item);
        if (index < 0 || index >= this.tags.size()) {
            this._visitables.get((Object)"tags").add(builder);
            this.tags.add(builder);
        } else {
            this._visitables.get((Object)"tags").set(index, builder);
            this.tags.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTags(TagReference ... items) {
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        for (TagReference item : items) {
            TagReferenceBuilder builder = new TagReferenceBuilder(item);
            this._visitables.get((Object)"tags").add(builder);
            this.tags.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToTags(Collection<TagReference> items) {
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        for (TagReference item : items) {
            TagReferenceBuilder builder = new TagReferenceBuilder(item);
            this._visitables.get((Object)"tags").add(builder);
            this.tags.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTags(TagReference ... items) {
        if (this.tags == null) {
            return (A)((Object)this);
        }
        for (TagReference item : items) {
            TagReferenceBuilder builder = new TagReferenceBuilder(item);
            this._visitables.get((Object)"tags").remove((Object)builder);
            this.tags.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTags(Collection<TagReference> items) {
        if (this.tags == null) {
            return (A)((Object)this);
        }
        for (TagReference item : items) {
            TagReferenceBuilder builder = new TagReferenceBuilder(item);
            this._visitables.get((Object)"tags").remove((Object)builder);
            this.tags.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTags(Predicate<TagReferenceBuilder> predicate) {
        if (this.tags == null) {
            return (A)((Object)this);
        }
        Iterator<TagReferenceBuilder> each = this.tags.iterator();
        List visitables = this._visitables.get((Object)"tags");
        while (each.hasNext()) {
            TagReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<TagReference> buildTags() {
        return this.tags != null ? ImageStreamSpecFluent.build(this.tags) : null;
    }

    public TagReference buildTag(int index) {
        return this.tags.get(index).build();
    }

    public TagReference buildFirstTag() {
        return this.tags.get(0).build();
    }

    public TagReference buildLastTag() {
        return this.tags.get(this.tags.size() - 1).build();
    }

    public TagReference buildMatchingTag(Predicate<TagReferenceBuilder> predicate) {
        for (TagReferenceBuilder item : this.tags) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTag(Predicate<TagReferenceBuilder> predicate) {
        for (TagReferenceBuilder item : this.tags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTags(List<TagReference> tags) {
        if (this.tags != null) {
            this._visitables.get((Object)"tags").clear();
        }
        if (tags != null) {
            this.tags = new ArrayList();
            for (TagReference item : tags) {
                this.addToTags(item);
            }
        } else {
            this.tags = null;
        }
        return (A)((Object)this);
    }

    public A withTags(TagReference ... tags) {
        if (this.tags != null) {
            this.tags.clear();
            this._visitables.remove((Object)"tags");
        }
        if (tags != null) {
            for (TagReference item : tags) {
                this.addToTags(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    public TagsNested<A> addNewTag() {
        return new TagsNested(-1, null);
    }

    public TagsNested<A> addNewTagLike(TagReference item) {
        return new TagsNested(-1, item);
    }

    public TagsNested<A> setNewTagLike(int index, TagReference item) {
        return new TagsNested(index, item);
    }

    public TagsNested<A> editTag(int index) {
        if (this.tags.size() <= index) {
            throw new RuntimeException("Can't edit tags. Index exceeds size.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    public TagsNested<A> editFirstTag() {
        if (this.tags.size() == 0) {
            throw new RuntimeException("Can't edit first tags. The list is empty.");
        }
        return this.setNewTagLike(0, this.buildTag(0));
    }

    public TagsNested<A> editLastTag() {
        int index = this.tags.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tags. The list is empty.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    public TagsNested<A> editMatchingTag(Predicate<TagReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tags.size(); ++i) {
            if (!predicate.test(this.tags.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tags. No match found.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageStreamSpecFluent that = (ImageStreamSpecFluent)((Object)o);
        if (!Objects.equals(this.dockerImageRepository, that.dockerImageRepository)) {
            return false;
        }
        if (!Objects.equals((Object)this.lookupPolicy, (Object)that.lookupPolicy)) {
            return false;
        }
        if (!Objects.equals(this.tags, that.tags)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dockerImageRepository, this.lookupPolicy, this.tags, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dockerImageRepository != null) {
            sb.append("dockerImageRepository:");
            sb.append(this.dockerImageRepository + ",");
        }
        if (this.lookupPolicy != null) {
            sb.append("lookupPolicy:");
            sb.append((Object)((Object)this.lookupPolicy) + ",");
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            sb.append("tags:");
            sb.append(this.tags + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TagsNested<N>
    extends TagReferenceFluent<TagsNested<N>>
    implements Nested<N> {
        TagReferenceBuilder builder;
        int index;

        TagsNested(int index, TagReference item) {
            this.index = index;
            this.builder = new TagReferenceBuilder(this, item);
        }

        public N and() {
            return (N)ImageStreamSpecFluent.this.setToTags(this.index, this.builder.build());
        }

        public N endTag() {
            return this.and();
        }
    }

    public class LookupPolicyNested<N>
    extends ImageLookupPolicyFluent<LookupPolicyNested<N>>
    implements Nested<N> {
        ImageLookupPolicyBuilder builder;

        LookupPolicyNested(ImageLookupPolicy item) {
            this.builder = new ImageLookupPolicyBuilder(this, item);
        }

        public N and() {
            return (N)ImageStreamSpecFluent.this.withLookupPolicy(this.builder.build());
        }

        public N endLookupPolicy() {
            return this.and();
        }
    }
}

