package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class BuildPostCommitSpecFluent<A extends BuildPostCommitSpecFluent<A>> extends BaseFluent<A>{
  public BuildPostCommitSpecFluent() {
  }
  
  public BuildPostCommitSpecFluent(BuildPostCommitSpec instance) {
    this.copyInstance(instance);
  }
  private List<String> args = new ArrayList<String>();
  private List<String> command = new ArrayList<String>();
  private String script;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(BuildPostCommitSpec instance) {
    instance = (instance != null ? instance : new BuildPostCommitSpec());
    if (instance != null) {
          this.withArgs(instance.getArgs());
          this.withCommand(instance.getCommand());
          this.withScript(instance.getScript());
          this.withArgs(instance.getArgs());
          this.withCommand(instance.getCommand());
          this.withScript(instance.getScript());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToArgs(int index,String item) {
    if (this.args == null) {this.args = new ArrayList<String>();}
    this.args.add(index, item);
    return (A)this;
  }
  
  public A setToArgs(int index,String item) {
    if (this.args == null) {this.args = new ArrayList<String>();}
    this.args.set(index, item); return (A)this;
  }
  
  public A addToArgs(java.lang.String... items) {
    if (this.args == null) {this.args = new ArrayList<String>();}
    for (String item : items) {this.args.add(item);} return (A)this;
  }
  
  public A addAllToArgs(Collection<String> items) {
    if (this.args == null) {this.args = new ArrayList<String>();}
    for (String item : items) {this.args.add(item);} return (A)this;
  }
  
  public A removeFromArgs(java.lang.String... items) {
    if (this.args == null) return (A)this;
    for (String item : items) { this.args.remove(item);} return (A)this;
  }
  
  public A removeAllFromArgs(Collection<String> items) {
    if (this.args == null) return (A)this;
    for (String item : items) { this.args.remove(item);} return (A)this;
  }
  
  public List<String> getArgs() {
    return this.args;
  }
  
  public String getArg(int index) {
    return this.args.get(index);
  }
  
  public String getFirstArg() {
    return this.args.get(0);
  }
  
  public String getLastArg() {
    return this.args.get(args.size() - 1);
  }
  
  public String getMatchingArg(Predicate<String> predicate) {
      for (String item : args) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingArg(Predicate<String> predicate) {
      for (String item : args) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withArgs(List<String> args) {
    if (args != null) {
        this.args = new ArrayList();
        for (String item : args) {
          this.addToArgs(item);
        }
    } else {
      this.args = null;
    }
    return (A) this;
  }
  
  public A withArgs(java.lang.String... args) {
    if (this.args != null) {this.args.clear(); _visitables.remove("args"); }
    if (args != null) {for (String item :args){ this.addToArgs(item);}} return (A) this;
  }
  
  public boolean hasArgs() {
    return this.args != null && !this.args.isEmpty();
  }
  
  public A addToCommand(int index,String item) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    this.command.add(index, item);
    return (A)this;
  }
  
  public A setToCommand(int index,String item) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    this.command.set(index, item); return (A)this;
  }
  
  public A addToCommand(java.lang.String... items) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    for (String item : items) {this.command.add(item);} return (A)this;
  }
  
  public A addAllToCommand(Collection<String> items) {
    if (this.command == null) {this.command = new ArrayList<String>();}
    for (String item : items) {this.command.add(item);} return (A)this;
  }
  
  public A removeFromCommand(java.lang.String... items) {
    if (this.command == null) return (A)this;
    for (String item : items) { this.command.remove(item);} return (A)this;
  }
  
  public A removeAllFromCommand(Collection<String> items) {
    if (this.command == null) return (A)this;
    for (String item : items) { this.command.remove(item);} return (A)this;
  }
  
  public List<String> getCommand() {
    return this.command;
  }
  
  public String getCommand(int index) {
    return this.command.get(index);
  }
  
  public String getFirstCommand() {
    return this.command.get(0);
  }
  
  public String getLastCommand() {
    return this.command.get(command.size() - 1);
  }
  
  public String getMatchingCommand(Predicate<String> predicate) {
      for (String item : command) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingCommand(Predicate<String> predicate) {
      for (String item : command) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withCommand(List<String> command) {
    if (command != null) {
        this.command = new ArrayList();
        for (String item : command) {
          this.addToCommand(item);
        }
    } else {
      this.command = null;
    }
    return (A) this;
  }
  
  public A withCommand(java.lang.String... command) {
    if (this.command != null) {this.command.clear(); _visitables.remove("command"); }
    if (command != null) {for (String item :command){ this.addToCommand(item);}} return (A) this;
  }
  
  public boolean hasCommand() {
    return this.command != null && !this.command.isEmpty();
  }
  
  public String getScript() {
    return this.script;
  }
  
  public A withScript(String script) {
    this.script = script;
    return (A) this;
  }
  
  public boolean hasScript() {
    return this.script != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BuildPostCommitSpecFluent that = (BuildPostCommitSpecFluent) o;
    if (!java.util.Objects.equals(args, that.args)) return false;
    if (!java.util.Objects.equals(command, that.command)) return false;
    if (!java.util.Objects.equals(script, that.script)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(args,  command,  script,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (args != null && !args.isEmpty()) { sb.append("args:"); sb.append(args + ","); }
    if (command != null && !command.isEmpty()) { sb.append("command:"); sb.append(command + ","); }
    if (script != null) { sb.append("script:"); sb.append(script + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}