package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ImageLookupPolicyBuilder extends ImageLookupPolicyFluent<ImageLookupPolicyBuilder> implements VisitableBuilder<ImageLookupPolicy,ImageLookupPolicyBuilder>{
  public ImageLookupPolicyBuilder() {
    this(new ImageLookupPolicy());
  }
  
  public ImageLookupPolicyBuilder(ImageLookupPolicyFluent<?> fluent) {
    this(fluent, new ImageLookupPolicy());
  }
  
  public ImageLookupPolicyBuilder(ImageLookupPolicyFluent<?> fluent,ImageLookupPolicy instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ImageLookupPolicyBuilder(ImageLookupPolicy instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ImageLookupPolicyFluent<?> fluent;
  
  public ImageLookupPolicy build() {
    ImageLookupPolicy buildable = new ImageLookupPolicy(fluent.getLocal());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}