package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OAuthAccessTokenListBuilder extends OAuthAccessTokenListFluent<OAuthAccessTokenListBuilder> implements VisitableBuilder<OAuthAccessTokenList,OAuthAccessTokenListBuilder>{
  public OAuthAccessTokenListBuilder() {
    this(new OAuthAccessTokenList());
  }
  
  public OAuthAccessTokenListBuilder(OAuthAccessTokenListFluent<?> fluent) {
    this(fluent, new OAuthAccessTokenList());
  }
  
  public OAuthAccessTokenListBuilder(OAuthAccessTokenListFluent<?> fluent,OAuthAccessTokenList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OAuthAccessTokenListBuilder(OAuthAccessTokenList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OAuthAccessTokenListFluent<?> fluent;
  
  public OAuthAccessTokenList build() {
    OAuthAccessTokenList buildable = new OAuthAccessTokenList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}